/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import io.quarkus.runtime.configuration.NameIterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

public final class ConfigDiagnostic {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static final List<String> errorsMessages = new CopyOnWriteArrayList<String>();

    private ConfigDiagnostic() {
    }

    public static void invalidValue(String name, IllegalArgumentException ex) {
        String message = ex.getMessage();
        String loggedMessage = String.format("An invalid value was given for configuration key \"%s\": %s", name, message == null ? ex.toString() : message);
        log.error((Object)loggedMessage);
        errorsMessages.add(loggedMessage);
    }

    public static void missingValue(String name, NoSuchElementException ex) {
        String message = ex.getMessage();
        String loggedMessage = String.format("Configuration key \"%s\" is required, but its value is empty/missing: %s", name, message == null ? ex.toString() : message);
        log.error((Object)loggedMessage);
        errorsMessages.add(loggedMessage);
    }

    public static void duplicate(String name) {
        String loggedMessage = String.format("Configuration key \"%s\" was specified more than once", name);
        errorsMessages.add(loggedMessage);
    }

    public static void deprecated(String name) {
        log.warnf("Configuration key \"%s\" is deprecated", (Object)name);
    }

    public static void unknown(String name) {
        log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored; verify that the dependency extension for this configuration is set or you did not make a typo", (Object)name);
    }

    public static void unknown(NameIterator name) {
        ConfigDiagnostic.unknown(name.getName());
    }

    public static void unknownRunTime(String name) {
        if (ImageInfo.inImageRuntimeCode()) {
            log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored; verify that the dependency extension for this configuration is set or that you did not make a typo", (Object)name);
        }
    }

    public static void unknownRunTime(NameIterator name) {
        ConfigDiagnostic.unknownRunTime(name.getName());
    }

    public static boolean isError() {
        return !errorsMessages.isEmpty();
    }

    public static void resetError() {
        errorsMessages.clear();
    }

    public static String getNiceErrorMessage() {
        return String.join((CharSequence)"\n", errorsMessages);
    }
}

