/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigSourceFactoryProvider;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.config.ConfigSourceFactory;
import java.lang.reflect.InvocationTargetException;

public class RuntimeConfigSourceFactory
implements ConfigSourceFactoryProvider {
    private final String configSourceFactoryClassName;

    public RuntimeConfigSourceFactory(String configSourceFactoryClassName) {
        this.configSourceFactoryClassName = configSourceFactoryClassName;
    }

    @Override
    public ConfigSourceFactory getConfigSourceFactory(ClassLoader forClassLoader) {
        try {
            Class<?> configSourceFactoryClass = forClassLoader.loadClass(this.configSourceFactoryClassName);
            return (ConfigSourceFactory)configSourceFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
    }
}

