/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class ExceptionUtil {
    public static String generateStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    public static String rootCauseFirstStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ArrayList<Throwable> exceptionChain = new ArrayList<Throwable>();
        for (Throwable curr = exception; curr != null; curr = curr.getCause()) {
            exceptionChain.add(0, curr);
        }
        Throwable prevStrippedCause = null;
        Throwable modifiedRoot = null;
        for (int i = 0; i < exceptionChain.size(); ++i) {
            Throwable x;
            Throwable throwable = x = prevStrippedCause == null ? ExceptionUtil.stripCause((Throwable)exceptionChain.get(0)) : prevStrippedCause;
            if (i != exceptionChain.size() - 1) {
                Throwable strippedCause = ExceptionUtil.stripCause((Throwable)exceptionChain.get(i + 1));
                x.initCause(strippedCause);
                prevStrippedCause = strippedCause;
            }
            if (i != 0) continue;
            modifiedRoot = x;
        }
        return ExceptionUtil.generateStackTrace(modifiedRoot).replace("Caused by:", "Resulted in:");
    }

    public static Throwable getRootCause(Throwable exception) {
        ArrayList<Throwable> chain = new ArrayList<Throwable>();
        for (Throwable curr = exception; curr != null && !chain.contains(curr); curr = curr.getCause()) {
            chain.add(curr);
        }
        return chain.isEmpty() ? null : (Throwable)chain.get(chain.size() - 1);
    }

    public static <T> boolean isAnyCauseInstanceOf(Throwable exception, Class<T> classToCheck) {
        Throwable curr = exception;
        do {
            if (!classToCheck.isInstance(curr)) continue;
            return true;
        } while ((curr = curr.getCause()) != null);
        return false;
    }

    private static Throwable stripCause(Throwable t) {
        Throwable stripped = ExceptionUtil.delegatingToStringThrowable(t);
        stripped.setStackTrace(t.getStackTrace());
        return stripped;
    }

    private static Throwable delegatingToStringThrowable(final Throwable t) {
        return new Throwable(){

            @Override
            public String toString() {
                return t.toString();
            }
        };
    }
}

