/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.runtime.ErrorPageAction;
import io.quarkus.runtime.logging.DecorateStackUtil;
import io.quarkus.runtime.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class TemplateHtmlBuilder {
    private static String CSS = null;
    private static final String SCRIPT_STACKTRACE_MANIPULATION = "<script>\n\tfunction toggleStackTraceOrder() {\n\t\tvar stElement = document.getElementById('stacktrace');\n\t\tvar current = stElement.getAttribute('data-current-setting');\n\t\tif (current == 'original-stacktrace') {\n\t\t\tvar reverseOrder = document.getElementById('reversed-stacktrace');\n\t\t\tstElement.innerHTML = reverseOrder.innerHTML;\n\t\t\tstElement.setAttribute('data-current-setting', 'reversed-stacktrace');\n\t\t} else {\n\t\t\tvar originalOrder = document.getElementById('original-stacktrace');\n\t\t\tstElement.innerHTML = originalOrder.innerHTML;\n\t\t\tstElement.setAttribute('data-current-setting', 'original-stacktrace');\n\t\t}\n\t\treturn;\n\t}\n\tfunction showDefaultStackTraceOrder() {\n\t\tvar reverseOrder = document.getElementById('reversed-stacktrace');\n\t\tvar stElement = document.getElementById('stacktrace');\n       if (reverseOrder == null || stElement == null) {\n           return;\n       }\n\t\t// default to reverse ordered stacktrace\n\t\tstElement.innerHTML = reverseOrder.innerHTML;\n\t\tstElement.setAttribute('data-current-setting', 'reversed-stacktrace');\n\t\treturn;\n\t}\n</script>\n";
    private static final String HTML_TEMPLATE_START = "<!doctype html>\n<html lang=\"en\">\n<head>\n    <title>%1$s%2$s</title>\n    <meta charset=\"utf-8\">\n    <style>%3$s</style>\n<script>\n\tfunction toggleStackTraceOrder() {\n\t\tvar stElement = document.getElementById('stacktrace');\n\t\tvar current = stElement.getAttribute('data-current-setting');\n\t\tif (current == 'original-stacktrace') {\n\t\t\tvar reverseOrder = document.getElementById('reversed-stacktrace');\n\t\t\tstElement.innerHTML = reverseOrder.innerHTML;\n\t\t\tstElement.setAttribute('data-current-setting', 'reversed-stacktrace');\n\t\t} else {\n\t\t\tvar originalOrder = document.getElementById('original-stacktrace');\n\t\t\tstElement.innerHTML = originalOrder.innerHTML;\n\t\t\tstElement.setAttribute('data-current-setting', 'original-stacktrace');\n\t\t}\n\t\treturn;\n\t}\n\tfunction showDefaultStackTraceOrder() {\n\t\tvar reverseOrder = document.getElementById('reversed-stacktrace');\n\t\tvar stElement = document.getElementById('stacktrace');\n       if (reverseOrder == null || stElement == null) {\n           return;\n       }\n\t\t// default to reverse ordered stacktrace\n\t\tstElement.innerHTML = reverseOrder.innerHTML;\n\t\tstElement.setAttribute('data-current-setting', 'reversed-stacktrace');\n\t\treturn;\n\t}\n</script>\n</head>\n<body  onload=\"showDefaultStackTraceOrder()\">\n<div class=\"header\">\n   <svg id=\"quarkus-logo-svg\" data-name=\"Quarkus Logo\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 1280 195\">\n       <defs>\n           <style>\n             .cls-1 {\n                   fill: #fff;\n               }\n               .cls-2 {\n                   fill: #4695eb;\n               }\n               .cls-3 {\n                   fill: #ff004a;\n               }\n           </style>\n       </defs>\n       <title>quarkus_logo_horizontal_rgb_1280px_reverse</title>\n       <path class=\"cls-1\"\n           d=\"M404,89.39q0,25.9-10.49,43.07a52.31,52.31,0,0,1-29.61,23.24l32.3,33.39H373.29l-26.45-30.44-5.11.19q-30,0-46.27-18.22T279.17,89.2q0-32.93,16.34-51.05T341.92,20q29.24,0,45.66,18.45T404,89.39Zm-108.14,0q0,27.39,11.74,41.55t34.11,14.15q22.56,0,34.07-14.11t11.51-41.59q0-27.21-11.47-41.27T341.92,34.05q-22.56,0-34.3,14.16T295.88,89.39Z\"/>\n       <path class=\"cls-1\"\n           d=\"M559.56,22.15V109.4q0,23.05-14,36.25T507,158.84q-24.51,0-37.92-13.29T455.7,109V22.15h15.78v88q0,16.88,9.28,25.91t27.29,9q17.16,0,26.45-9.08T543.78,110V22.15Z\"/>\n       <path class=\"cls-1\"\n           d=\"M703.6,157,686.7,114.1H632.31L615.6,157h-16L653.29,21.6h13.27L719.93,157Zm-21.82-57L666,58.21q-3.07-7.92-6.32-19.46a172.55,172.55,0,0,1-5.85,19.46l-16,41.78Z\"/>\n       <path class=\"cls-1\"\n           d=\"M777.19,100.92V157H761.4V22.15h37.23q25,0,36.89,9.5t11.93,28.59q0,26.74-27.29,36.16L857,157H838.35l-32.86-56.07Zm0-13.47h21.62q16.71,0,24.51-6.6t7.79-19.78q0-13.37-7.93-19.27T797.7,35.89H777.19Z\"/>\n       <path class=\"cls-1\"\n           d=\"M999.75,157H981.18L931.71,91.6l-14.2,12.54V157H901.73V22.15h15.78V89l61.54-66.87h18.66L943.13,80.72Z\"/>\n       <path class=\"cls-1\"\n           d=\"M1143.69,22.15V109.4q0,23.05-14,36.25t-38.52,13.19q-24.5,0-37.92-13.29T1039.82,109V22.15h15.78v88q0,16.88,9.28,25.91t27.29,9q17.17,0,26.46-9.08t9.28-26.06V22.15Z\"/>\n       <path class=\"cls-1\"\n           d=\"M1279,121.11q0,17.8-13,27.76t-35.28,10q-24.13,0-37.13-6.18V137.53a97.82,97.82,0,0,0,18.2,5.53,95.67,95.67,0,0,0,19.49,2q15.78,0,23.76-6t8-16.55q0-7-2.83-11.48t-9.46-8.26q-6.65-3.78-20.19-8.58-18.94-6.72-27.06-16t-8.12-24.07q0-15.58,11.79-24.81t31.18-9.22a92.55,92.55,0,0,1,37.22,7.37l-4.91,13.65q-16.82-7-32.68-7-12.53,0-19.58,5.35t-7.06,14.85q0,7,2.6,11.48t8.77,8.21q6.18,3.73,18.89,8.26,21.36,7.56,29.38,16.23T1279,121.11Z\"/>\n       <polygon class=\"cls-2\" points=\"126.05 34.6 96.61 51.59 126.05 68.59 126.05 34.6\"/>\n       <polygon class=\"cls-3\" points=\"67.17 34.6 67.17 68.59 96.61 51.59 67.17 34.6\"/>\n       <polygon class=\"cls-1\" points=\"126.05 68.59 96.61 51.59 67.17 68.59 96.61 85.59 126.05 68.59\"/>\n       <polygon class=\"cls-2\" points=\"36.13 88.36 65.57 105.36 65.57 71.37 36.13 88.36\"/>\n       <polygon class=\"cls-3\" points=\"65.57 139.35 95.01 122.36 65.57 105.36 65.57 139.35\"/>\n       <polygon class=\"cls-1\" points=\"65.57 71.37 65.57 105.36 95.01 122.36 95.01 88.36 65.57 71.37\"/>\n       <polygon class=\"cls-2\" points=\"127.65 139.35 127.65 105.36 98.21 122.36 127.65 139.35\"/>\n       <polygon class=\"cls-3\" points=\"157.09 88.36 127.65 71.37 127.65 105.36 157.09 88.36\"/>\n       <polygon class=\"cls-1\" points=\"98.21 122.36 127.65 105.36 127.65 71.37 98.21 88.36 98.21 122.36\"/>\n       <path class=\"cls-2\"\n           d=\"M160.5,1H32.72A31.81,31.81,0,0,0,1,32.72V160.5a31.81,31.81,0,0,0,31.72,31.72h87.51L96.61,134.85,79.48,171.07H32.72A10.71,10.71,0,0,1,22.15,160.5V32.72A10.71,10.71,0,0,1,32.72,22.15H160.5a10.71,10.71,0,0,1,10.57,10.57V160.5a10.71,10.71,0,0,1-10.57,10.57H132.77l8.71,21.15h19a31.81,31.81,0,0,0,31.72-31.72V32.72A31.81,31.81,0,0,0,160.5,1Z\"/>\n   </svg>\n</div> ";
    private static final String HTML_TEMPLATE_END = "</div></body>\n</html>\n";
    private static final String HEADER_TEMPLATE = "<div class=\"banner\">\n                            <div class=\"callout\">%1$s</div>\n                        </div><header>\n    <div class=\"exception-message\">\n        <h2 class=\"container\">%2$s</h2>\n        <div class=\"actions\">%3$s</div>\n    </div>\n</header>\n<div class=\"container content\">\n";
    private static final String RESOURCES_START = "<div class=\"intro\">%1$s</div><div class=\"resources\">";
    private static final String ANCHOR_TEMPLATE_ABSOLUTE = "<a href=\"%1$s\">%2$s</a>";
    private static final String DESCRIPTION_TEMPLATE = "%1$s \u2014 %2$s";
    private static final String RESOURCE_TEMPLATE = "<h3>%1$s</h3>\n";
    private static final String LIST_START = "<ul>\n";
    private static final String METHOD_START = "<li> %1$s <strong>%2$s</strong>\n    <ul>\n";
    private static final String METHOD_IO = "<li>%1$s: %2$s</li>\n";
    private static final String LIST_ITEM = "<li>%s</li>\n";
    private static final String METHOD_END = "    </ul>\n</li>";
    private static final String LIST_END = "</ul>\n";
    private static final String RESOURCES_END = "</div>";
    private static final String STACKTRACE_DISPLAY_DIV = "<div id=\"stacktrace\"></div>";
    private static final String BRSTI = "___begin_relative_stack_trace_item___";
    private static final String ERSTI = "___end_relative_stack_trace_item___";
    private static final String OPEN_IDE_LINK = "<div class='rel-stacktrace-item' onclick=\"event.preventDefault(); fetch('/q/open-in-ide/%s/%s/%d');\">";
    private static final String ERROR_STACK = "    <div id=\"original-stacktrace\" class=\"trace hidden\">\n<h3>The stacktrace below is the original. <a href=\"\" onClick=\"toggleStackTraceOrder(); return false;\">See the stacktrace in reversed order</a> (root-cause first)</h4>        <code class=\"stacktrace\"><pre>%1$s<pre></code>\n    </div>\n";
    private static final String ERROR_STACK_REVERSED = "    <div id=\"reversed-stacktrace\" class=\"trace hidden\">\n<h3>The stacktrace below has been reversed to show the root cause first. <a href=\"\" onClick=\"toggleStackTraceOrder(); return false;\">See the original stacktrace</a></h3>        <code class=\"stacktrace\"><pre>%1$s</pre></code>\n    </div>\n";
    private static final String DECORATE_DIV = "<pre class='decorate'>%s</pre>";
    private static final String CONFIG_EDITOR_HEAD = "<h3>The following incorrect config values were detected:</h3><form class=\"updateConfigForm\" method=\"post\" enctype=\"application/x-www-form-urlencoded\"  action=\"/io.quarkus.vertx-http.devmode.config.fix\"><input type=\"hidden\" name=\"redirect\" value=\"%s\"/>\n";
    private static final String CONFIG_EDITOR_ROW = "<code class=\"configKey\">%s\n</code>\n                <input class=\"configValue\" type=\"text\" name=\"key.%s\" value=\"%s\"/>\n";
    private static final String CONFIG_UPDATE_BUTTON = "<input class=\"cta-button\" type=\"submit\" value=\"Update\" >";
    private static final String CONFIG_EDITOR_TAIL = "    </tbody>\n</table><input class=\"cta-button\" type=\"submit\" value=\"Update\" ></form>";
    private StringBuilder result;
    private String baseUrl;

    public TemplateHtmlBuilder(String title, String subTitle, String details) {
        this(null, title, subTitle, details, Collections.emptyList(), null, Collections.emptyList());
    }

    public TemplateHtmlBuilder(String title, String subTitle, String details, List<ErrorPageAction> actions) {
        this(null, title, subTitle, details, actions, null, Collections.emptyList());
    }

    public TemplateHtmlBuilder(String baseUrl, String title, String subTitle, String details, List<ErrorPageAction> actions) {
        this(baseUrl, title, subTitle, details, actions, null, Collections.emptyList());
    }

    public TemplateHtmlBuilder(String title, String subTitle, String details, List<ErrorPageAction> actions, String redirect, List<CurrentConfig> config) {
        this(null, title, subTitle, details, actions, null, Collections.emptyList());
    }

    public TemplateHtmlBuilder(String baseUrl, String title, String subTitle, String details, List<ErrorPageAction> actions, String redirect, List<CurrentConfig> config) {
        this.baseUrl = baseUrl;
        this.loadCssFile();
        StringBuilder actionLinks = new StringBuilder();
        for (ErrorPageAction epa : actions) {
            actionLinks.append(this.buildLink(epa.name(), epa.url()));
        }
        this.result = new StringBuilder(String.format(HTML_TEMPLATE_START, TemplateHtmlBuilder.escapeHtml(title), subTitle == null || subTitle.isEmpty() ? "" : " - " + TemplateHtmlBuilder.escapeHtml(subTitle), CSS));
        this.result.append(String.format(HEADER_TEMPLATE, TemplateHtmlBuilder.escapeHtml(title), TemplateHtmlBuilder.escapeHtml(details), actionLinks.toString()));
        if (!config.isEmpty()) {
            this.result.append(String.format(CONFIG_EDITOR_HEAD, redirect));
            for (CurrentConfig i : config) {
                this.result.append(String.format(CONFIG_EDITOR_ROW, TemplateHtmlBuilder.escapeHtml(i.getPropertyName()), TemplateHtmlBuilder.escapeHtml(i.getPropertyName()), TemplateHtmlBuilder.escapeHtml(i.getCurrentValue())));
            }
            this.result.append(CONFIG_EDITOR_TAIL);
        }
    }

    public TemplateHtmlBuilder decorate(Throwable throwable, String srcMainJava, List<String> knowClasses) {
        String decoratedString = DecorateStackUtil.getDecoratedString(throwable, srcMainJava, knowClasses);
        if (decoratedString != null) {
            this.result.append(String.format(DECORATE_DIV, decoratedString));
        }
        return this;
    }

    public TemplateHtmlBuilder stack(Throwable throwable) {
        return this.stack(throwable, List.of());
    }

    public TemplateHtmlBuilder stack(Throwable throwable, List<String> knowClasses) {
        if (knowClasses != null && throwable != null) {
            StackTraceElement[] originalStackTrace = Arrays.copyOf(throwable.getStackTrace(), throwable.getStackTrace().length);
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            String className = "";
            String type = "java";
            int lineNumber = 0;
            if (!knowClasses.isEmpty()) {
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement elem = stackTrace[i];
                    className = elem.getClassName();
                    String filename = elem.getFileName();
                    if (filename != null) {
                        int dotindex = filename.lastIndexOf(".");
                        type = elem.getFileName().substring(dotindex + 1);
                    }
                    lineNumber = elem.getLineNumber();
                    if (!knowClasses.contains(elem.getClassName())) continue;
                    stackTrace[i] = new StackTraceElement(elem.getClassLoaderName(), elem.getModuleName(), elem.getModuleVersion(), BRSTI + elem.getClassName() + ERSTI, elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
                }
            }
            throwable.setStackTrace(stackTrace);
            String original = TemplateHtmlBuilder.escapeHtml(ExceptionUtil.generateStackTrace(throwable));
            String rootFirst = TemplateHtmlBuilder.escapeHtml(ExceptionUtil.rootCauseFirstStackTrace(throwable));
            if (original.contains(BRSTI)) {
                original = original.replace(BRSTI, String.format(OPEN_IDE_LINK, className, type, lineNumber));
                original = original.replace(ERSTI, RESOURCES_END);
                rootFirst = rootFirst.replace(BRSTI, String.format(OPEN_IDE_LINK, className, type, lineNumber));
                rootFirst = rootFirst.replace(ERSTI, RESOURCES_END);
            }
            this.result.append(String.format(ERROR_STACK, original));
            this.result.append(String.format(ERROR_STACK_REVERSED, rootFirst));
            this.result.append(STACKTRACE_DISPLAY_DIV);
            throwable.setStackTrace(originalStackTrace);
        }
        return this;
    }

    public TemplateHtmlBuilder resourcesStart(String title) {
        this.result.append(String.format(RESOURCES_START, title));
        return this;
    }

    public TemplateHtmlBuilder resourcesEnd() {
        this.result.append(RESOURCES_END);
        return this;
    }

    public TemplateHtmlBuilder noResourcesFound() {
        this.result.append(String.format(RESOURCE_TEMPLATE, "No resources discovered"));
        return this;
    }

    public TemplateHtmlBuilder resourcePath(String title) {
        return this.resourcePath(title, true, false, null);
    }

    public TemplateHtmlBuilder staticResourcePath(String title) {
        return this.staticResourcePath(title, null);
    }

    public TemplateHtmlBuilder staticResourcePath(String title, String description) {
        return this.resourcePath(title, false, true, description);
    }

    public TemplateHtmlBuilder servletMapping(String title) {
        return this.resourcePath(title, false, true, null);
    }

    private TemplateHtmlBuilder resourcePath(String title, boolean withListStart, boolean withAnchor, String description) {
        String content;
        if (withAnchor) {
            String text = title;
            if (((String)title).startsWith("/")) {
                title = ((String)title).substring(1);
            }
            if (!((String)title).startsWith("http") && this.baseUrl != null) {
                title = this.baseUrl + (String)title;
            }
            if (((String)title).startsWith("http")) {
                int firstSlashIndex = ((String)title).indexOf("/", ((String)title).indexOf("//") + 2);
                text = ((String)title).substring(firstSlashIndex);
            }
            content = String.format(ANCHOR_TEMPLATE_ABSOLUTE, title, TemplateHtmlBuilder.escapeHtml(text));
        } else {
            content = TemplateHtmlBuilder.escapeHtml((String)title);
        }
        if (description != null && !description.isEmpty()) {
            content = String.format(DESCRIPTION_TEMPLATE, content, description);
        }
        this.result.append(String.format(RESOURCE_TEMPLATE, content));
        if (withListStart) {
            this.result.append(LIST_START);
        }
        return this;
    }

    public TemplateHtmlBuilder method(String method, String fullPath) {
        fullPath = TemplateHtmlBuilder.escapeHtml((String)fullPath);
        if (method.equalsIgnoreCase("GET")) {
            fullPath = this.baseUrl != null ? "<a href='" + this.baseUrl + ((String)fullPath).substring(1) + "' target='_blank'>" + (String)fullPath + "</a>" : "<a href='" + (String)fullPath + "' target='_blank'>" + (String)fullPath + "</a>";
        }
        this.result.append(String.format(METHOD_START, TemplateHtmlBuilder.escapeHtml(method), fullPath));
        return this;
    }

    public TemplateHtmlBuilder consumes(String consumes) {
        this.result.append(String.format(METHOD_IO, "Consumes", TemplateHtmlBuilder.escapeHtml(consumes)));
        return this;
    }

    public TemplateHtmlBuilder produces(String produces) {
        this.result.append(String.format(METHOD_IO, "Produces", TemplateHtmlBuilder.escapeHtml(produces)));
        return this;
    }

    public TemplateHtmlBuilder listItem(String content) {
        this.result.append(String.format(LIST_ITEM, TemplateHtmlBuilder.escapeHtml(content)));
        return this;
    }

    public TemplateHtmlBuilder methodEnd() {
        this.result.append(METHOD_END);
        return this;
    }

    public TemplateHtmlBuilder resourceStart() {
        this.result.append(LIST_START);
        return this;
    }

    public TemplateHtmlBuilder resourceEnd() {
        this.result.append(LIST_END);
        return this;
    }

    public TemplateHtmlBuilder append(String html) {
        this.result.append(html);
        return this;
    }

    public String toString() {
        return this.result.append(HTML_TEMPLATE_END).toString();
    }

    private static String escapeHtml(String bodyText) {
        if (bodyText == null) {
            return "";
        }
        return bodyText.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String adjustRoot(String httpRoot, String basePath) {
        if (httpRoot.equals("/")) {
            return basePath;
        }
        if (basePath.startsWith("/")) {
            if (!httpRoot.endsWith("/")) {
                return httpRoot + basePath;
            }
            return httpRoot.substring(0, httpRoot.length() - 1) + basePath;
        }
        if (httpRoot.endsWith("/")) {
            return httpRoot.substring(1) + basePath;
        }
        return httpRoot.substring(1) + "/" + basePath;
    }

    public void loadCssFile() {
        block15: {
            if (CSS == null) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                String cssFilePath = "META-INF/template-html-builder.css";
                try (InputStream inputStream = classLoader.getResourceAsStream(cssFilePath);){
                    if (inputStream == null) break block15;
                    try (Scanner scanner = new Scanner(inputStream, "UTF-8");){
                        StringBuilder stringBuilder = new StringBuilder();
                        while (scanner.hasNextLine()) {
                            stringBuilder.append(scanner.nextLine()).append("\n");
                        }
                        CSS = stringBuilder.toString();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private String buildLink(String name, String url) {
        return "<a href=" + url + ">" + name + "</a>";
    }
}

