/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import jakarta.annotation.Priority;
import java.io.Serializable;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class DurationConverter
implements Converter<Duration>,
Serializable {
    private static final long serialVersionUID = 7499347081928776532L;
    private static final String PERIOD = "P";
    private static final String PERIOD_OF_TIME = "PT";
    public static final Pattern DIGITS = Pattern.compile("^[-+]?\\d+$");
    private static final Pattern DIGITS_AND_UNIT = Pattern.compile("^[-+]?\\d+(?:\\.\\d+)?(?i)[hms]$");
    private static final Pattern DAYS = Pattern.compile("^[-+]?\\d+(?i)d$");
    private static final Pattern MILLIS = Pattern.compile("^[-+]?\\d+(?i)ms$");

    public Duration convert(String value) {
        return DurationConverter.parseDuration(value);
    }

    public static Duration parseDuration(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (DIGITS.asPredicate().test(value)) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        if (MILLIS.asPredicate().test(value)) {
            return Duration.ofMillis(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        try {
            if (DIGITS_AND_UNIT.asPredicate().test(value)) {
                return Duration.parse(PERIOD_OF_TIME + value);
            }
            if (DAYS.asPredicate().test(value)) {
                return Duration.parse(PERIOD + value);
            }
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

