/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensionResult;
import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.SelectionResult;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public class AddExtensions {
    private BuildFile buildFile;
    private static final Printer PRINTER = new Printer();

    public AddExtensions(ProjectWriter writer) throws IOException {
        this(writer, BuildTool.MAVEN);
    }

    public AddExtensions(ProjectWriter writer, BuildTool buildTool) throws IOException {
        this.buildFile = buildTool.getBuildFile(writer);
    }

    static SelectionResult select(String query, List<Extension> extensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        Set<Extension> matchesNameOrArtifactId = extensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || AddExtensions.matchesArtifactId(extension.getArtifactId(), q)).collect(Collectors.toSet());
        if (matchesNameOrArtifactId.size() == 1) {
            return new SelectionResult(matchesNameOrArtifactId, true);
        }
        Set<Extension> matchesShortName = extensions.stream().filter(extension -> AddExtensions.matchesShortName(extension, q)).collect(Collectors.toSet());
        if (matchesShortName.size() == 1 && matchesNameOrArtifactId.isEmpty()) {
            return new SelectionResult(matchesShortName, true);
        }
        Set<Extension> partialMatches = extensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifactId().toLowerCase().contains(q) || extension.getShortName().toLowerCase().contains(q)).collect(Collectors.toSet());
        if (partialMatches.size() == 1 && matchesNameOrArtifactId.isEmpty() && matchesShortName.isEmpty()) {
            return new SelectionResult(partialMatches, true);
        }
        List<Object> matchesLabels = labelLookup ? extensions.stream().filter(extension -> extension.labels().contains(q)).collect(Collectors.toList()) : new ArrayList();
        LinkedHashSet<Extension> candidates = new LinkedHashSet<Extension>();
        candidates.addAll(matchesNameOrArtifactId);
        candidates.addAll(matchesShortName);
        candidates.addAll(partialMatches);
        candidates.addAll(matchesLabels);
        return new SelectionResult(candidates, false);
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(extension.getShortName());
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }

    public AddExtensionResult addExtensions(Set<String> extensions) throws IOException {
        if (extensions == null || extensions.isEmpty()) {
            return new AddExtensionResult(false, true);
        }
        boolean updated = false;
        boolean success = true;
        List<Dependency> dependenciesFromBom = this.getDependenciesFromBom();
        List<Extension> registry = MojoUtils.loadExtensions();
        for (String query : extensions) {
            if (query.contains(":")) {
                updated = this.buildFile.addExtensionAsGAV(query) || updated;
                continue;
            }
            SelectionResult result = AddExtensions.select(query, registry, false);
            if (!result.matches()) {
                StringBuilder sb = new StringBuilder();
                Set<Extension> candidates = result.getExtensions();
                if (candidates.isEmpty()) {
                    PRINTER.nok(" Cannot find a dependency matching '" + query + "', maybe a typo?");
                    success = false;
                    continue;
                }
                sb.append("\u274c").append(" Multiple extensions matching '").append(query).append("'");
                result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
                sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
                PRINTER.print(sb.toString());
                success = false;
                continue;
            }
            Extension extension2 = result.getMatch();
            updated = this.buildFile.addDependency(dependenciesFromBom, extension2) || updated;
        }
        if (updated) {
            this.buildFile.write();
        }
        return new AddExtensionResult(updated, success);
    }

    private List<Dependency> getDependenciesFromBom() {
        try {
            return MojoUtils.readPom(this.getClass().getResourceAsStream("/quarkus-bom/pom.xml")).getDependencyManagement().getDependencies();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the BOM file: " + e.getMessage(), e);
        }
    }
}

