/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.generators;

public enum SourceType {
    JAVA(".java"),
    KOTLIN(".kt");

    private static final String srcDirPrefix = "src/main/";
    private static final String testSrcDirPrefix = "src/test/";
    private static final String BUILD_FILE_RESOURCE_TEMPLATE = "templates/%s/%s/%s-template.ftl";
    private static final String RESOURCE_TEMPLATE = "templates/%s/%s/resource-template.ftl";
    private static final String SPRING_CONTROLLER_TEMPLATE = "templates/%s/%s/spring-controller-template.ftl";
    private static final String TEST_RESOURCE_TEMPLATE = "templates/%s/%s/test-resource-template.ftl";
    private static final String NATIVE_TEST_RESOURCE_TEMPLATE = "templates/%s/%s/native-test-resource-template.ftl";
    private final String extension;

    private SourceType(String extension) {
        this.extension = extension;
    }

    public String getSrcDir() {
        return srcDirPrefix + this.getPathDiscriminator();
    }

    private String getPathDiscriminator() {
        return this.name().toLowerCase();
    }

    public String getTestSrcDir() {
        return testSrcDirPrefix + this.getPathDiscriminator();
    }

    public String getBuildFileResourceTemplate(String templateName, String buildFile) {
        return this.computeTemplateFile(BUILD_FILE_RESOURCE_TEMPLATE, templateName, buildFile);
    }

    public String getSrcResourceTemplate(String templateName) {
        return this.computeTemplateFile(RESOURCE_TEMPLATE, templateName);
    }

    public String getSrcSpringControllerTemplate(String templateName) {
        return this.computeTemplateFile(SPRING_CONTROLLER_TEMPLATE, templateName);
    }

    public String getTestResourceTemplate(String templateName) {
        return this.computeTemplateFile(TEST_RESOURCE_TEMPLATE, templateName);
    }

    public String getNativeTestResourceTemplate(String templateName) {
        return this.computeTemplateFile(NATIVE_TEST_RESOURCE_TEMPLATE, templateName);
    }

    public String getExtension() {
        return this.extension;
    }

    public String stripExtensionFrom(String className) {
        if (className != null && className.endsWith(this.extension)) {
            return className.substring(0, className.length() - this.extension.length());
        }
        return className;
    }

    private String computeTemplateFile(String genericTemplate, String templateName) {
        return this.computeTemplateFile(genericTemplate, templateName, null);
    }

    private String computeTemplateFile(String genericTemplate, String templateName, String fileName) {
        return String.format(genericTemplate, templateName, this.getPathDiscriminator(), fileName);
    }
}

