/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.quarkus.grpc.runtime.stork.GrpcStorkServiceDiscovery;
import io.quarkus.grpc.runtime.stork.StorkMeasuringCollector;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceInstance;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class GrpcLoadBalancerProvider
extends LoadBalancerProvider {
    private static final Logger log = Logger.getLogger(GrpcLoadBalancerProvider.class);
    private final boolean requestConnections;

    public GrpcLoadBalancerProvider(boolean requestConnections) {
        this.requestConnections = requestConnections;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 4;
    }

    public String getPolicyName() {
        return "stork";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        String serviceName;
        try {
            serviceName = JsonUtil.getString(rawConfig, (String)"service-name");
        }
        catch (RuntimeException e) {
            log.error((Object)("Failed to parse Stork configuration: " + String.valueOf(rawConfig)), (Throwable)e);
            return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL);
        }
        if (serviceName == null) {
            log.error((Object)("No 'service-name' defined in the Stork for gRPC configuration: " + String.valueOf(rawConfig)));
            return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL);
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new StorkLoadBalancerConfig(serviceName));
    }

    public LoadBalancer newLoadBalancer(final LoadBalancer.Helper helper) {
        return new LoadBalancer(){
            String serviceName;

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                List addresses = resolvedAddresses.getAddresses();
                Object loadBalancerConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
                if (!(loadBalancerConfig instanceof StorkLoadBalancerConfig)) {
                    throw new IllegalStateException("invalid configuration for a Stork Load Balancer : " + String.valueOf(loadBalancerConfig));
                }
                StorkLoadBalancerConfig config = (StorkLoadBalancerConfig)loadBalancerConfig;
                TreeMap<ServiceInstance, LoadBalancer.Subchannel> subChannels = new TreeMap<ServiceInstance, LoadBalancer.Subchannel>(Comparator.comparingLong(ServiceInstance::getId));
                final Set<ServiceInstance> activeSubchannels = Collections.newSetFromMap(new ConcurrentHashMap());
                final AtomicReference<ConnectivityState> state = new AtomicReference<ConnectivityState>(ConnectivityState.CONNECTING);
                this.serviceName = config.serviceName;
                final StorkSubchannelPicker picker = new StorkSubchannelPicker(subChannels, this.serviceName, activeSubchannels);
                for (EquivalentAddressGroup addressGroup : addresses) {
                    final ServiceInstance serviceInstance = (ServiceInstance)addressGroup.getAttributes().get(GrpcStorkServiceDiscovery.SERVICE_INSTANCE);
                    LoadBalancer.CreateSubchannelArgs subChannelArgs = LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(addressGroup).setAttributes(addressGroup.getAttributes()).build();
                    LoadBalancer.Subchannel subchannel = helper.createSubchannel(subChannelArgs);
                    subchannel.start(new LoadBalancer.SubchannelStateListener(){

                        public void onSubchannelState(ConnectivityStateInfo stateInfo) {
                            if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE || stateInfo.getState() == ConnectivityState.IDLE) {
                                Status status = stateInfo.getStatus();
                                log.error((Object)"gRPC Sub Channel failed", status == null ? null : status.getCause());
                                helper.refreshNameResolution();
                            }
                            log.debugf("subchannel changed state to %s for %s", (Object)stateInfo.getState(), (Object)serviceInstance.getId());
                            switch (stateInfo.getState()) {
                                case READY: {
                                    activeSubchannels.add(serviceInstance);
                                    if (state.getAndSet(ConnectivityState.READY) == ConnectivityState.READY) break;
                                    helper.updateBalancingState((ConnectivityState)state.get(), (LoadBalancer.SubchannelPicker)picker);
                                    break;
                                }
                                case CONNECTING: 
                                case TRANSIENT_FAILURE: 
                                case IDLE: 
                                case SHUTDOWN: {
                                    activeSubchannels.remove(serviceInstance);
                                    if (!activeSubchannels.isEmpty() || !state.compareAndSet(ConnectivityState.READY, stateInfo.getState())) break;
                                    helper.updateBalancingState((ConnectivityState)state.get(), (LoadBalancer.SubchannelPicker)picker);
                                }
                            }
                        }
                    });
                    if (GrpcLoadBalancerProvider.this.requestConnections) {
                        subchannel.requestConnection();
                    }
                    subChannels.put(serviceInstance, subchannel);
                }
                helper.updateBalancingState(state.get(), (LoadBalancer.SubchannelPicker)picker);
            }

            public void handleNameResolutionError(Status error) {
                log.errorf("Name resolution failed for service '%s'", (Object)this.serviceName);
            }

            public void shutdown() {
                log.debugf("Shutting down load balancer for service '%s'", (Object)this.serviceName);
            }
        };
    }

    static class StorkLoadBalancerConfig {
        final String serviceName;

        StorkLoadBalancerConfig(String serviceName) {
            this.serviceName = serviceName;
        }
    }

    static class StorkSubchannelPicker
    extends LoadBalancer.SubchannelPicker {
        private final Map<ServiceInstance, LoadBalancer.Subchannel> subChannels;
        private final String serviceName;
        private final Set<ServiceInstance> activeServiceInstances;

        StorkSubchannelPicker(Map<ServiceInstance, LoadBalancer.Subchannel> subChannels, String serviceName, Set<ServiceInstance> activeServiceInstances) {
            this.subChannels = subChannels;
            this.serviceName = serviceName;
            this.activeServiceInstances = activeServiceInstances;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            Boolean measureTime = (Boolean)StorkMeasuringCollector.STORK_MEASURE_TIME.get();
            measureTime = measureTime != null && measureTime != false;
            ServiceInstance serviceInstance = this.pickServerInstance(measureTime);
            LoadBalancer.Subchannel subchannel = this.subChannels.get(serviceInstance);
            if (serviceInstance.gatherStatistics() && StorkMeasuringCollector.STORK_SERVICE_INSTANCE.get() != null) {
                ((AtomicReference)StorkMeasuringCollector.STORK_SERVICE_INSTANCE.get()).set(serviceInstance);
                return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
            }
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
        }

        private ServiceInstance pickServerInstance(boolean measureTime) {
            Service service = Stork.getInstance().getService(this.serviceName);
            Set<ServiceInstance> toChooseFrom = this.activeServiceInstances;
            if (this.activeServiceInstances.isEmpty()) {
                toChooseFrom = this.subChannels.keySet();
                log.debugf("no active service instances, using all subChannels: %s", toChooseFrom);
            }
            return service.selectInstanceAndRecordStart(toChooseFrom, measureTime);
        }
    }
}

