/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.generateconfig.ConfigPhaseOutcome;
import io.quarkus.creator.phase.generateconfig.GenerateConfigPhase;
import io.quarkus.maven.MojoLogger;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-config", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateConfigMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${file}")
    private String file;

    public GenerateConfigMojo() {
        MojoLogger.logSupplier = () -> ((GenerateConfigMojo)this).getLog();
    }

    public void execute() throws MojoExecutionException {
        AppModel appModel;
        BootstrapAppModelResolver modelResolver;
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping generate-config goal");
            return;
        }
        Artifact projectArtifact = this.project.getArtifact();
        AppArtifact appArtifact = new AppArtifact(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getClassifier(), "pom", projectArtifact.getVersion());
        try {
            LocalProject localProject = LocalProject.load((Path)this.project.getBasedir().toPath());
            modelResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).setWorkspace(localProject.getWorkspace()).build());
            appModel = modelResolver.resolveModel(appArtifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve application model " + appArtifact + " dependencies", e);
        }
        if (this.project.getResources().isEmpty()) {
            throw new MojoExecutionException("No resources directory, cannot create application.properties");
        }
        Resource res = (Resource)this.project.getResources().get(0);
        File target = new File(res.getDirectory());
        String name = this.file;
        if (name == null || name.isEmpty()) {
            name = "application.properties.example";
        }
        try (AppCreator appCreator = AppCreator.builder().addPhase((AppCreationPhase)new GenerateConfigPhase().setConfigFile(new File(target, name).toPath())).setWorkDir(this.buildDir.toPath()).build();){
            appCreator.pushOutcome((Object)CurateOutcome.builder().setAppModelResolver((AppModelResolver)modelResolver).setAppModel(appModel).build());
            appCreator.resolveOutcome(ConfigPhaseOutcome.class);
            this.getLog().info((CharSequence)("Generated config file " + name));
        }
        catch (AppCreatorException e) {
            throw new MojoExecutionException("Failed to generate config file", (Exception)((Object)e));
        }
    }
}

