/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.nativeimage.NativeImageOutcome;
import io.quarkus.creator.phase.nativeimage.NativeImagePhase;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import io.quarkus.maven.MojoLogger;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="native-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NativeImageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/wiring-classes")
    private File wiringClassesDirectory;
    @Parameter(defaultValue="false")
    private boolean reportErrorsAtRuntime;
    @Parameter(defaultValue="false")
    private boolean debugSymbols;
    @Parameter(defaultValue="${native-image.debug-build-process}")
    private boolean debugBuildProcess;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${native-image.new-server}")
    private boolean cleanupServer;
    @Parameter
    private boolean enableHttpUrlHandler;
    @Parameter
    private boolean enableHttpsUrlHandler;
    @Parameter
    private boolean enableAllSecurityServices;
    @Parameter
    private boolean enableRetainedHeapReporting;
    @Parameter
    private boolean enableIsolates;
    @Parameter
    private boolean enableCodeSizeReporting;
    @Parameter(defaultValue="${env.GRAALVM_HOME}")
    private String graalvmHome;
    @Parameter(defaultValue="false")
    private boolean enableServer;
    @Parameter(defaultValue="false")
    private boolean enableJni;
    @Parameter(defaultValue="false")
    private boolean autoServiceLoaderRegistration;
    @Parameter(defaultValue="false")
    private boolean dumpProxies;
    @Parameter(defaultValue="${native-image.xmx}")
    private String nativeImageXmx;
    @Parameter(defaultValue="${native-image.docker-build}")
    private String dockerBuild;
    @Parameter(defaultValue="${native-image.container-runtime}")
    private String containerRuntime;
    @Parameter(defaultValue="${native-image.container-runtime-options}")
    private String containerRuntimeOptions;
    @Parameter(defaultValue="false")
    private boolean enableVMInspection;
    @Parameter(defaultValue="true")
    private boolean fullStackTraces;
    @Parameter(defaultValue="${native-image.disable-reports}")
    private boolean disableReports;
    @Parameter
    private List<String> additionalBuildArgs;
    @Parameter(defaultValue="false")
    private boolean addAllCharsets;
    @Parameter(defaultValue="false")
    private boolean enableFallbackImages;
    @Parameter(defaultValue="true")
    private boolean reportExceptionStackTraces;

    public NativeImageMojo() {
        MojoLogger.logSupplier = () -> ((NativeImageMojo)this).getLog();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping native-image goal");
            return;
        }
        if (!this.buildDir.isDirectory() || !new File(this.buildDir, "lib").isDirectory()) {
            throw new MojoFailureException("Unable to find the required build output. Please ensure that the 'build' goal has been properly configured for the project - since it is a prerequisite of the 'native-image' goal");
        }
        try (AppCreator appCreator = AppCreator.builder().addPhase((AppCreationPhase)new NativeImagePhase().setAddAllCharsets(this.addAllCharsets).setAdditionalBuildArgs(this.additionalBuildArgs).setAutoServiceLoaderRegistration(this.autoServiceLoaderRegistration).setOutputDir(this.buildDir.toPath()).setCleanupServer(this.cleanupServer).setDebugBuildProcess(this.debugBuildProcess).setDebugSymbols(this.debugSymbols).setDisableReports(this.disableReports).setDockerBuild(this.dockerBuild).setContainerRuntime(this.containerRuntime).setContainerRuntimeOptions(this.containerRuntimeOptions).setDumpProxies(this.dumpProxies).setEnableAllSecurityServices(this.enableAllSecurityServices).setEnableCodeSizeReporting(this.enableCodeSizeReporting).setEnableFallbackImages(this.enableFallbackImages).setEnableHttpsUrlHandler(this.enableHttpsUrlHandler).setEnableHttpUrlHandler(this.enableHttpUrlHandler).setEnableIsolates(this.enableIsolates).setEnableJni(this.enableJni).setEnableRetainedHeapReporting(this.enableRetainedHeapReporting).setEnableServer(this.enableServer).setEnableVMInspection(this.enableVMInspection).setFullStackTraces(this.fullStackTraces).setGraalvmHome(this.graalvmHome).setNativeImageXmx(this.nativeImageXmx).setReportErrorsAtRuntime(this.reportErrorsAtRuntime).setReportExceptionStackTraces(this.reportExceptionStackTraces)).build();){
            appCreator.pushOutcome(AugmentOutcome.class, (Object)new AugmentOutcome(){
                final Path classesDir;
                {
                    this.classesDir = new File(NativeImageMojo.this.outputDirectory, "classes").toPath();
                }

                public Path getAppClassesDir() {
                    return this.classesDir;
                }

                public Path getTransformedClassesDir() {
                    throw new UnsupportedOperationException();
                }

                public Path getWiringClassesDir() {
                    throw new UnsupportedOperationException();
                }

                public Path getConfigDir() {
                    return this.classesDir;
                }

                public Map<Path, Set<String>> getTransformedClassesByJar() {
                    return Collections.emptyMap();
                }
            }).pushOutcome(RunnerJarOutcome.class, (Object)new RunnerJarOutcome(){
                final Path runnerJar;
                final Path originalJar;
                {
                    this.runnerJar = NativeImageMojo.this.buildDir.toPath().resolve(NativeImageMojo.this.finalName + "-runner.jar");
                    this.originalJar = NativeImageMojo.this.buildDir.toPath().resolve(NativeImageMojo.this.finalName + ".jar");
                }

                public Path getRunnerJar() {
                    return this.runnerJar;
                }

                public Path getLibDir() {
                    return this.runnerJar.getParent().resolve("lib");
                }

                public Path getOriginalJar() {
                    return this.originalJar;
                }
            }).resolveOutcome(NativeImageOutcome.class);
        }
        catch (AppCreatorException e) {
            throw new MojoExecutionException("Failed to generate a native image", (Exception)((Object)e));
        }
    }
}

