/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import io.quarkus.maven.utilities.MojoUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MavenVersionEnforcer.class, instantiationStrategy="per-lookup")
public class MavenVersionEnforcer {
    public void ensureMavenVersion(Log log, MavenSession session) throws MojoExecutionException {
        String supported = MojoUtils.get((String)"supported-maven-versions");
        String mavenVersion = session.getSystemProperties().getProperty("maven.version");
        log.debug((CharSequence)("Detected Maven Version: " + mavenVersion));
        DefaultArtifactVersion detectedVersion = new DefaultArtifactVersion(mavenVersion);
        this.enforce(log, supported, (ArtifactVersion)detectedVersion);
    }

    private void enforce(Log log, String requiredMavenVersionRange, ArtifactVersion actualMavenVersion) throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)requiredMavenVersionRange)) {
            throw new MojoExecutionException("Maven version can't be empty.");
        }
        String msg = "Detected Maven Version (" + actualMavenVersion + ") ";
        if (actualMavenVersion.toString().equals(requiredMavenVersionRange)) {
            log.debug((CharSequence)(msg + " is allowed in " + requiredMavenVersionRange + "."));
        } else {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredMavenVersionRange);
                if (!MavenVersionEnforcer.containsVersion(vr, actualMavenVersion)) {
                    String message = msg + " is not supported, it must be in " + vr + ".";
                    throw new MojoExecutionException(message);
                }
                log.debug((CharSequence)(msg + " is allowed in " + requiredMavenVersionRange + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("The requested Maven version " + requiredMavenVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    private static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        boolean matched = false;
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                matched = true;
                break;
            }
        } else {
            int compareTo = recommendedVersion.compareTo((Object)theVersion);
            matched = compareTo <= 0;
        }
        return matched;
    }
}

