/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.BuildMojo;
import io.quarkus.maven.Deployer;
import io.quarkus.maven.ImageBuilder;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class AbstractDeploymentMojo
extends BuildMojo {
    Optional<String> deployer = Optional.empty();
    @Parameter(property="quarkus.deployment.dry-run")
    boolean dryRun;
    @Parameter(property="quarkus.container-image.build", defaultValue="false")
    boolean imageBuild;
    @Parameter(property="quarkus.container-image.builder")
    String imageBuilder;
    boolean forceDependencies = true;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"Deployment configuration:");
            this.systemProperties.entrySet().stream().filter(e -> ((String)e.getKey()).contains("quarkus.deployment")).forEach(e -> this.getLog().info((CharSequence)(" - " + (String)e.getKey() + ": " + (String)e.getValue())));
        } else {
            super.doExecute();
        }
    }

    public Deployer getDeployer() {
        return this.getDeployer(Deployer.kubernetes);
    }

    public Deployer getDeployer(Deployer defaultDeployer) {
        return Deployer.getDeployer(this.mavenProject()).orElse(defaultDeployer);
    }

    @Override
    protected List<Dependency> forcedDependencies(LaunchMode mode) {
        if (!this.forceDependencies) {
            return super.forcedDependencies(mode);
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        MavenProject project = this.mavenProject();
        Deployer deployer = this.getDeployer();
        deployer.getExtensionArtifact(project).ifPresent(d -> dependencies.add((Dependency)d));
        if (this.imageBuild || this.imageBuilder != null) {
            Set<ImageBuilder> projectBuilders = ImageBuilder.getProjectBuilder(project).stream().map(ImageBuilder::valueOf).collect(Collectors.toSet());
            Optional<ImageBuilder> imageBuilder = ImageBuilder.getBuilder(this.imageBuilder, projectBuilders);
            imageBuilder.filter(b -> !projectBuilders.contains(b)).flatMap(b -> b.getExtensionArtifact(project)).ifPresent(d -> dependencies.add((Dependency)d));
        }
        return dependencies;
    }
}

