/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.tracing;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonDocument;
import org.jboss.logging.Logger;

public class MongoTracingCommandListener
implements CommandListener {
    private static final Logger LOGGER = Logger.getLogger(MongoTracingCommandListener.class);
    private static final String KEY = "mongodb.command";
    private final Map<Integer, ContextEvent> requestMap = new ConcurrentHashMap<Integer, ContextEvent>();
    private final Instrumenter<MongoCommand, Void> instrumenter;

    @Inject
    public MongoTracingCommandListener(OpenTelemetry openTelemetry) {
        SpanNameExtractor spanNameExtractor = MongoCommand::name;
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"quarkus-mongodb-client", (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)new CommandEventAttrExtractor()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        LOGGER.debugf("MongoTracingCommandListener created", new Object[0]);
    }

    public void commandStarted(CommandStartedEvent event) {
        LOGGER.tracef("commandStarted event %s", (Object)event.getCommandName());
        Context parentContext = Optional.ofNullable(event.getRequestContext()).map(rc -> {
            Context ctx = (Context)rc.get((Object)"otel.context.current");
            rc.delete((Object)"otel.context.current");
            return ctx;
        }).orElseGet(Context::current);
        MongoCommand mongoCommand = new MongoCommand(event.getCommandName(), event.getCommand());
        if (this.instrumenter.shouldStart(parentContext, (Object)mongoCommand)) {
            Context context = this.instrumenter.start(parentContext, (Object)mongoCommand);
            this.requestMap.put(event.getRequestId(), new ContextEvent(context, mongoCommand));
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        LOGGER.tracef("commandSucceeded event %s", (Object)event.getCommandName());
        ContextEvent contextEvent = this.requestMap.remove(event.getRequestId());
        if (contextEvent != null) {
            this.instrumenter.end(contextEvent.context(), (Object)contextEvent.command(), null, null);
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        LOGGER.tracef("commandFailed event %s", (Object)event.getCommandName());
        ContextEvent contextEvent = this.requestMap.remove(event.getRequestId());
        if (contextEvent != null) {
            this.instrumenter.end(contextEvent.context(), (Object)contextEvent.command(), null, event.getThrowable());
        }
    }

    private static class CommandEventAttrExtractor
    implements AttributesExtractor<MongoCommand, Void> {
        private CommandEventAttrExtractor() {
        }

        public void onStart(AttributesBuilder attributesBuilder, Context context, MongoCommand command) {
            attributesBuilder.put(MongoTracingCommandListener.KEY, command.command().toJson());
        }

        public void onEnd(AttributesBuilder attributesBuilder, Context context, MongoCommand command, Void unused, Throwable throwable) {
        }
    }

    private record MongoCommand(String name, BsonDocument command) {
    }

    private record ContextEvent(Context context, MongoCommand command) {
    }
}

