/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.builders;

import io.quarkus.oidc.OidcTenantConfigBuilder;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public final class TokenConfigBuilder {
    private final OidcTenantConfigBuilder builder;
    private final Map<String, String> requiredClaims = new HashMap<String, String>();
    private final List<String> audience = new ArrayList<String>();
    private Optional<String> issuer;
    private boolean subjectRequired;
    private Optional<String> tokenType;
    private OptionalInt lifespanGrace;
    private Optional<Duration> age;
    private boolean issuedAtRequired;
    private Optional<String> principalClaim;
    private boolean refreshExpired;
    private Optional<Duration> refreshTokenTimeSkew;
    private Duration forcedJwkRefreshInterval;
    private Optional<String> header;
    private String authorizationScheme;
    private Optional<OidcTenantConfig.SignatureAlgorithm> signatureAlgorithm;
    private Optional<String> decryptionKeyLocation;
    private boolean allowJwtIntrospection;
    private boolean requireJwtIntrospectionOnly;
    private boolean allowOpaqueTokenIntrospection;
    private Optional<String> customizerName;
    private Optional<Boolean> verifyAccessTokenWithUserInfo;
    private OidcTenantConfig.Binding binding;

    public TokenConfigBuilder() {
        this(new OidcTenantConfigBuilder());
    }

    public TokenConfigBuilder(OidcTenantConfigBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
        OidcTenantConfig.Token token = builder.getToken();
        if (!token.requiredClaims().isEmpty()) {
            this.requiredClaims.putAll(token.requiredClaims());
        }
        if (token.audience().isPresent()) {
            this.audience.addAll((Collection<String>)token.audience().get());
        }
        this.issuer = token.issuer();
        this.subjectRequired = token.subjectRequired();
        this.tokenType = token.tokenType();
        this.lifespanGrace = token.lifespanGrace();
        this.age = token.age();
        this.issuedAtRequired = token.issuedAtRequired();
        this.principalClaim = token.principalClaim();
        this.refreshExpired = token.refreshExpired();
        this.refreshTokenTimeSkew = token.refreshTokenTimeSkew();
        this.forcedJwkRefreshInterval = token.forcedJwkRefreshInterval();
        this.header = token.header();
        this.authorizationScheme = token.authorizationScheme();
        this.signatureAlgorithm = token.signatureAlgorithm();
        this.decryptionKeyLocation = token.decryptionKeyLocation();
        this.allowJwtIntrospection = token.allowJwtIntrospection();
        this.requireJwtIntrospectionOnly = token.requireJwtIntrospectionOnly();
        this.allowOpaqueTokenIntrospection = token.allowOpaqueTokenIntrospection();
        this.customizerName = token.customizerName();
        this.verifyAccessTokenWithUserInfo = token.verifyAccessTokenWithUserInfo();
        this.binding = token.binding();
    }

    public OidcTenantConfigBuilder end() {
        return this.builder.token(this.build());
    }

    public TokenConfigBuilder requiredClaims(String requiredClaimName, String requiredClaimValue) {
        Objects.requireNonNull(requiredClaimName);
        Objects.requireNonNull(requiredClaimValue);
        this.requiredClaims.put(requiredClaimName, requiredClaimValue);
        return this;
    }

    public TokenConfigBuilder requiredClaims(Map<String, String> requiredClaims) {
        if (requiredClaims != null) {
            this.requiredClaims.putAll(requiredClaims);
        }
        return this;
    }

    public TokenConfigBuilder audience(String ... audience) {
        if (audience != null) {
            this.audience.addAll(Arrays.asList(audience));
        }
        return this;
    }

    public TokenConfigBuilder audience(List<String> audience) {
        if (audience != null) {
            this.audience.addAll(audience);
        }
        return this;
    }

    public TokenConfigBuilder issuer(String issuer) {
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    public TokenConfigBuilder subjectRequired() {
        return this.subjectRequired(true);
    }

    public TokenConfigBuilder subjectRequired(boolean subjectRequired) {
        this.subjectRequired = subjectRequired;
        return this;
    }

    public TokenConfigBuilder tokenType(String tokenType) {
        this.tokenType = Optional.ofNullable(tokenType);
        return this;
    }

    public TokenConfigBuilder lifespanGrace(int lifespanGrace) {
        this.lifespanGrace = OptionalInt.of(lifespanGrace);
        return this;
    }

    public TokenConfigBuilder age(Duration age) {
        this.age = Optional.ofNullable(age);
        return this;
    }

    public TokenConfigBuilder issuedAtRequired() {
        return this.issuedAtRequired(true);
    }

    public TokenConfigBuilder issuedAtRequired(boolean issuedAtRequired) {
        this.issuedAtRequired = issuedAtRequired;
        return this;
    }

    public TokenConfigBuilder principalClaim(String principalClaim) {
        this.principalClaim = Optional.ofNullable(principalClaim);
        return this;
    }

    public TokenConfigBuilder refreshExpired() {
        return this.refreshExpired(true);
    }

    public TokenConfigBuilder refreshExpired(boolean refreshExpired) {
        this.refreshExpired = refreshExpired;
        return this;
    }

    public TokenConfigBuilder refreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
        this.refreshTokenTimeSkew = Optional.ofNullable(refreshTokenTimeSkew);
        return this;
    }

    public TokenConfigBuilder forcedJwkRefreshInterval(Duration forcedJwkRefreshInterval) {
        this.forcedJwkRefreshInterval = Objects.requireNonNull(forcedJwkRefreshInterval);
        return this;
    }

    public TokenConfigBuilder header(String header) {
        this.header = Optional.ofNullable(header);
        return this;
    }

    public TokenConfigBuilder authorizationScheme(String authorizationScheme) {
        this.authorizationScheme = Objects.requireNonNull(authorizationScheme);
        return this;
    }

    public TokenConfigBuilder signatureAlgorithm(OidcTenantConfig.SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = Optional.ofNullable(signatureAlgorithm);
        return this;
    }

    public TokenConfigBuilder decryptionKeyLocation(String decryptionKeyLocation) {
        this.decryptionKeyLocation = Optional.ofNullable(decryptionKeyLocation);
        return this;
    }

    public TokenConfigBuilder allowJwtIntrospection() {
        return this.allowJwtIntrospection(true);
    }

    public TokenConfigBuilder allowJwtIntrospection(boolean allowJwtIntrospection) {
        this.allowJwtIntrospection = allowJwtIntrospection;
        return this;
    }

    public TokenConfigBuilder requireJwtIntrospectionOnly() {
        return this.requireJwtIntrospectionOnly(true);
    }

    public TokenConfigBuilder requireJwtIntrospectionOnly(boolean requireJwtIntrospectionOnly) {
        this.requireJwtIntrospectionOnly = requireJwtIntrospectionOnly;
        return this;
    }

    public TokenConfigBuilder allowOpaqueTokenIntrospection() {
        return this.allowOpaqueTokenIntrospection(true);
    }

    public TokenConfigBuilder allowOpaqueTokenIntrospection(boolean allowOpaqueTokenIntrospection) {
        this.allowOpaqueTokenIntrospection = allowOpaqueTokenIntrospection;
        return this;
    }

    public TokenConfigBuilder customizerName(String customizerName) {
        this.customizerName = Optional.ofNullable(customizerName);
        return this;
    }

    public TokenConfigBuilder verifyAccessTokenWithUserInfo() {
        return this.verifyAccessTokenWithUserInfo(true);
    }

    public TokenConfigBuilder verifyAccessTokenWithUserInfo(boolean verifyAccessTokenWithUserInfo) {
        this.verifyAccessTokenWithUserInfo = Optional.of(verifyAccessTokenWithUserInfo);
        return this;
    }

    public BindingConfigBuilder binding() {
        return new BindingConfigBuilder(this);
    }

    public TokenConfigBuilder binding(OidcTenantConfig.Binding binding) {
        this.binding = Objects.requireNonNull(binding);
        return this;
    }

    public OidcTenantConfig.Binding getBinding() {
        return this.binding;
    }

    public OidcTenantConfig.Token build() {
        Optional<List<String>> optionalAudience = this.audience.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.audience));
        return new TokenImpl(this.issuer, optionalAudience, this.subjectRequired, Map.copyOf(this.requiredClaims), this.tokenType, this.lifespanGrace, this.age, this.issuedAtRequired, this.principalClaim, this.refreshExpired, this.refreshTokenTimeSkew, this.forcedJwkRefreshInterval, this.header, this.authorizationScheme, this.signatureAlgorithm, this.decryptionKeyLocation, this.allowJwtIntrospection, this.requireJwtIntrospectionOnly, this.allowOpaqueTokenIntrospection, this.customizerName, this.verifyAccessTokenWithUserInfo, this.binding);
    }

    public static final class BindingConfigBuilder {
        private final TokenConfigBuilder builder;
        private boolean certificate;

        public BindingConfigBuilder() {
            this(new TokenConfigBuilder());
        }

        public BindingConfigBuilder(TokenConfigBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
            OidcTenantConfig.Binding binding = builder.getBinding();
            this.certificate = binding.certificate();
        }

        public TokenConfigBuilder end() {
            return this.builder.binding(this.build());
        }

        public BindingConfigBuilder certificate() {
            return this.certificate(true);
        }

        public BindingConfigBuilder certificate(boolean certificate) {
            this.certificate = certificate;
            return this;
        }

        public OidcTenantConfig.Binding build() {
            return new BindingImpl(this.certificate);
        }

        private record BindingImpl(boolean certificate) implements OidcTenantConfig.Binding
        {
        }
    }

    private record TokenImpl(Optional<String> issuer, Optional<List<String>> audience, boolean subjectRequired, Map<String, String> requiredClaims, Optional<String> tokenType, OptionalInt lifespanGrace, Optional<Duration> age, boolean issuedAtRequired, Optional<String> principalClaim, boolean refreshExpired, Optional<Duration> refreshTokenTimeSkew, Duration forcedJwkRefreshInterval, Optional<String> header, String authorizationScheme, Optional<OidcTenantConfig.SignatureAlgorithm> signatureAlgorithm, Optional<String> decryptionKeyLocation, boolean allowJwtIntrospection, boolean requireJwtIntrospectionOnly, boolean allowOpaqueTokenIntrospection, Optional<String> customizerName, Optional<Boolean> verifyAccessTokenWithUserInfo, OidcTenantConfig.Binding binding) implements OidcTenantConfig.Token
    {
    }
}

