/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.providers.KnownOidcProviders;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class OidcConfigPropertySupplier
implements Supplier<String> {
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String END_SESSION_PATH_CONFIG_KEY = "quarkus.oidc.end-session-path";
    private static final String TOKEN_PATH_CONFIG_KEY = "quarkus.oidc.token-path";
    private static final String AUTH_PATH_CONFIG_KEY = "quarkus.oidc.authorization-path";
    private static final Set<String> RELATIVE_PATH_CONFIG_PROPS = Set.of("quarkus.oidc.end-session-path", "quarkus.oidc.token-path", "quarkus.oidc.authorization-path");
    private static final String OIDC_PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private static final String SCOPES_KEY = "quarkus.oidc.authentication.scopes";
    private String oidcConfigProperty;
    private String defaultValue;
    private boolean urlProperty;

    public OidcConfigPropertySupplier() {
    }

    public OidcConfigPropertySupplier(String oidcConfigProperty) {
        this(oidcConfigProperty, null);
    }

    public OidcConfigPropertySupplier(String oidcConfigProperty, String defaultValue) {
        this(oidcConfigProperty, defaultValue, false);
    }

    public OidcConfigPropertySupplier(String oidcConfigProperty, String defaultValue, boolean urlProperty) {
        this.oidcConfigProperty = oidcConfigProperty;
        this.defaultValue = defaultValue;
        this.urlProperty = urlProperty;
    }

    @Override
    public String get() {
        return this.get(ConfigProvider.getConfig());
    }

    private String checkUrlProperty(Optional<String> value, OidcTenantConfig providerConfig, Config config) {
        if (this.urlProperty && value.isPresent() && !value.get().startsWith("http:")) {
            Optional authServerUrl = config.getOptionalValue(AUTH_SERVER_URL_CONFIG_KEY, String.class);
            if (authServerUrl.isEmpty() && providerConfig != null) {
                authServerUrl = providerConfig.authServerUrl;
            }
            return authServerUrl.isPresent() ? OidcCommonUtils.getOidcEndpointUrl((String)((String)authServerUrl.get()), value) : null;
        }
        return value.orElse(null);
    }

    public String getOidcConfigProperty() {
        return this.oidcConfigProperty;
    }

    public void setOidcConfigProperty(String oidcConfigProperty) {
        this.oidcConfigProperty = oidcConfigProperty;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isUrlProperty() {
        return this.urlProperty;
    }

    public void setUrlProperty(boolean urlProperty) {
        this.urlProperty = urlProperty;
    }

    public String get(Config config) {
        OidcTenantConfig providerConfig;
        Optional provider = config.getOptionalValue(OIDC_PROVIDER_CONFIG_KEY, OidcTenantConfig.Provider.class);
        OidcTenantConfig oidcTenantConfig = providerConfig = provider.isPresent() ? KnownOidcProviders.provider((OidcTenantConfig.Provider)((Object)provider.get())) : null;
        if (this.defaultValue != null || RELATIVE_PATH_CONFIG_PROPS.contains(this.oidcConfigProperty)) {
            Optional<String> value = config.getOptionalValue(this.oidcConfigProperty, String.class);
            if (value.isEmpty() && providerConfig != null) {
                if (END_SESSION_PATH_CONFIG_KEY.equals(this.oidcConfigProperty)) {
                    value = providerConfig.endSessionPath;
                } else if (TOKEN_PATH_CONFIG_KEY.equals(this.oidcConfigProperty)) {
                    value = providerConfig.tokenPath;
                } else if (AUTH_PATH_CONFIG_KEY.equals(this.oidcConfigProperty)) {
                    value = providerConfig.authorizationPath;
                }
            }
            if (value.isPresent()) {
                return this.checkUrlProperty(value, providerConfig, config);
            }
            return this.defaultValue;
        }
        if (SCOPES_KEY.equals(this.oidcConfigProperty)) {
            Optional<List<String>> scopes = config.getOptionalValues(this.oidcConfigProperty, String.class);
            if (scopes.isEmpty() && providerConfig != null) {
                scopes = providerConfig.authentication.scopes;
            }
            if (scopes.isPresent()) {
                Object scopesString = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)scopes.get());
                if (!scopes.get().contains("openid")) {
                    scopesString = (String)scopesString + " openid";
                }
                return OidcCommonUtils.urlEncode((String)scopesString);
            }
            return "openid";
        }
        return this.checkUrlProperty(config.getOptionalValue(this.oidcConfigProperty, String.class), providerConfig, config);
    }
}

