/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.sortedset;

public class ScoreRange<T extends Number> {
    private final Number min;
    private final Number max;
    private final boolean inclusiveMin;
    private final boolean inclusiveMax;
    public static final ScoreRange<?> UNBOUNDED = new ScoreRange<Object>(null, null);

    public static ScoreRange<Double> from(int min, int max) {
        return new ScoreRange<Double>(Double.valueOf(min), Double.valueOf(max));
    }

    public static ScoreRange<Double> from(long min, long max) {
        return new ScoreRange<Double>(Double.valueOf(min), Double.valueOf(max));
    }

    public static ScoreRange<Double> from(double min, double max) {
        return new ScoreRange<Double>(min, max);
    }

    public ScoreRange(T min, T max) {
        this.min = min;
        this.max = max;
        this.inclusiveMin = true;
        this.inclusiveMax = true;
    }

    public ScoreRange(T min, boolean inclusiveMin, T max, boolean inclusiveMax) {
        this.min = min;
        this.max = max;
        this.inclusiveMin = inclusiveMin;
        this.inclusiveMax = inclusiveMax;
    }

    public static ScoreRange<Double> unbounded() {
        return new ScoreRange<Object>(null, null);
    }

    public boolean isUnbounded() {
        if (this == UNBOUNDED || this.min == null && this.max == null) {
            return true;
        }
        return this.min != null && Double.isInfinite(this.min.doubleValue()) && this.max != null && Double.isInfinite(this.max.doubleValue());
    }

    public String getLowerBound() {
        if (this.isUnbounded() || this.min == null || Double.isInfinite(this.min.doubleValue())) {
            return "-inf";
        }
        if (!this.inclusiveMin) {
            return "(" + this.min;
        }
        return this.min.toString();
    }

    public String getUpperBound() {
        if (this.isUnbounded() || this.max == null || Double.isInfinite(this.max.doubleValue())) {
            return "+inf";
        }
        if (!this.inclusiveMax) {
            return "(" + this.max;
        }
        return this.max.toString();
    }
}

