/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.bloom.BfInsertArgs;
import io.quarkus.redis.datasource.bloom.BfReserveArgs;
import io.quarkus.redis.datasource.bloom.BloomCommands;
import io.quarkus.redis.datasource.bloom.ReactiveBloomCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;

public class BlockingBloomCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements BloomCommands<K, V> {
    private final ReactiveBloomCommands<K, V> reactive;

    public BlockingBloomCommandsImpl(RedisDataSource ds, ReactiveBloomCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public boolean bfadd(K key, V value) {
        return (Boolean)this.reactive.bfadd(key, value).await().atMost(this.timeout);
    }

    @Override
    public boolean bfexists(K key, V value) {
        return (Boolean)this.reactive.bfexists(key, value).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> bfmadd(K key, V ... values) {
        return (List)this.reactive.bfmadd(key, values).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> bfmexists(K key, V ... values) {
        return (List)this.reactive.bfmexists(key, values).await().atMost(this.timeout);
    }

    @Override
    public void bfreserve(K key, double errorRate, long capacity) {
        this.reactive.bfreserve(key, errorRate, capacity).await().atMost(this.timeout);
    }

    @Override
    public void bfreserve(K key, double errorRate, long capacity, BfReserveArgs args) {
        this.reactive.bfreserve(key, errorRate, capacity, args).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> bfinsert(K key, BfInsertArgs args, V ... values) {
        return (List)this.reactive.bfinsert(key, args, values).await().atMost(this.timeout);
    }
}

