/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.CertificateAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

@Singleton
public class X509IdentityProvider
implements IdentityProvider<CertificateAuthenticationRequest> {
    private static final String COMMON_NAME = "CN";
    private static final String ROLES_ATTRIBUTE = "roles";

    public Class<CertificateAuthenticationRequest> getRequestType() {
        return CertificateAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(CertificateAuthenticationRequest request, AuthenticationRequestContext context) {
        X509Certificate certificate = request.getCertificate().getCertificate();
        Map roles = (Map)request.getAttribute(ROLES_ATTRIBUTE);
        return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder().setPrincipal(certificate.getSubjectX500Principal()).addCredential((Credential)request.getCertificate()).addRoles(this.extractRoles(certificate, roles)).build());
    }

    private Set<String> extractRoles(X509Certificate certificate, Map<String, Set<String>> roles) {
        if (roles == null) {
            return Set.of();
        }
        X500Principal principal = certificate.getSubjectX500Principal();
        if (principal == null || principal.getName() == null) {
            return Set.of();
        }
        Set<String> matchedRoles = roles.get(principal.getName());
        if (matchedRoles != null) {
            return matchedRoles;
        }
        String commonName = X509IdentityProvider.getCommonName(principal);
        if (commonName != null && (matchedRoles = roles.get(commonName)) != null) {
            return matchedRoles;
        }
        return Set.of();
    }

    public static String getCommonName(X500Principal principal) {
        try {
            LdapName ldapDN = new LdapName(principal.getName());
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!COMMON_NAME.equals(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }
}

