/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.h2;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.h2.tools.Server;

public class H2DatabaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private Server tcpServer;

    public Map<String, String> start() {
        try {
            this.tcpServer = Server.createTcpServer((String[])new String[0]);
            this.tcpServer.start();
            System.out.println("[INFO] H2 database started in TCP server mode; server status: " + this.tcpServer.getStatus());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }

    public synchronized void stop() {
        if (this.tcpServer != null) {
            this.tcpServer.stop();
            System.out.println("[INFO] H2 database was shut down; server status: " + this.tcpServer.getStatus());
            this.tcpServer = null;
        }
    }
}

