/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import java.util.function.Supplier;
import ratpack.func.Action;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.CachingBackedRegistry;
import ratpack.registry.internal.DefaultRegistryBuilder;
import ratpack.registry.internal.EmptyRegistry;

public abstract class Registries {
    private Registries() {
    }

    public static <T> Registry just(Class<T> publicType, Supplier<? extends T> supplier) {
        return Registries.registry().addLazy(publicType, (Supplier)supplier).build();
    }

    public static Registry just(Object object) {
        return Registries.registry().add(object).build();
    }

    public static <T> Registry just(Class<? super T> publicType, T implementation) {
        return Registries.registry().add(publicType, (Object)implementation).build();
    }

    public static RegistryBuilder registry() {
        return new DefaultRegistryBuilder();
    }

    public static Registry empty() {
        return EmptyRegistry.INSTANCE;
    }

    public static Registry registry(Action<? super RegistrySpec> action) throws Exception {
        RegistryBuilder builder = Registries.registry();
        action.execute(builder);
        return builder.build();
    }

    public static Registry backedRegistry(RegistryBacking registryBacking) {
        return new CachingBackedRegistry(registryBacking);
    }
}

