/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.event.internal.DefaultEventController;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.func.Action;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.internal.DefaultDirectChannelAccess;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DescribingHandler;
import ratpack.handling.internal.DescribingHandlers;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.registry.Registry;
import ratpack.render.internal.DefaultRenderController;
import ratpack.server.ServerConfig;
import ratpack.server.internal.DefaultResponseTransmitter;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final AttributeKey<DefaultResponseTransmitter> RESPONSE_TRANSMITTER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)DefaultResponseTransmitter.class.getName());
    private static final AttributeKey<Action<Object>> CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"ratpack.subscriber");
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final Handler[] handlers;
    private final DefaultContext.ApplicationConstants applicationConstants;
    private final ExecController execController;
    private final Registry serverRegistry;
    private final boolean development;
    private final ExecControl execControl;

    public NettyHandlerAdapter(Registry serverRegistry, Handler handler) throws Exception {
        super(false);
        this.handlers = ChainHandler.unpack(handler);
        this.serverRegistry = serverRegistry;
        this.applicationConstants = new DefaultContext.ApplicationConstants(this.serverRegistry, new DefaultRenderController(), Handlers.notFound());
        this.execController = serverRegistry.get(ExecController.class);
        this.execControl = this.execController.getControl();
        this.development = serverRegistry.get(ServerConfig.class).isDevelopment();
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object msg) throws Exception {
        Action subscriber;
        if (!(msg instanceof FullHttpRequest) && (subscriber = (Action)channelHandlerContext.attr(CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY).get()) != null) {
            subscriber.execute(msg);
            return;
        }
        super.channelRead(channelHandlerContext, msg);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest nettyRequest) throws Exception {
        if (!nettyRequest.decoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            nettyRequest.release();
            return;
        }
        Channel channel = ctx.channel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        DefaultRequest request = new DefaultRequest(new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.method(), nettyRequest.uri(), remoteAddress, socketAddress, nettyRequest.content());
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(false);
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)nettyHeaders);
        DefaultEventController<RequestOutcome> requestOutcomeEventController = new DefaultEventController<RequestOutcome>();
        AtomicBoolean transmitted = new AtomicBoolean(false);
        DefaultResponseTransmitter responseTransmitter = new DefaultResponseTransmitter(transmitted, this.execControl, channel, nettyRequest, request, (HttpHeaders)nettyHeaders, requestOutcomeEventController);
        ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).set((Object)responseTransmitter);
        Action<Action<Object>> subscribeHandler = thing -> {
            transmitted.set(true);
            ctx.attr(CHANNEL_SUBSCRIBER_ATTRIBUTE_KEY).set(thing);
        };
        DefaultDirectChannelAccess directChannelAccess = new DefaultDirectChannelAccess(channel, subscribeHandler);
        DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, request, directChannelAccess, requestOutcomeEventController.getRegistry());
        DefaultResponse response = new DefaultResponse(responseHeaders, ctx.alloc(), responseTransmitter);
        requestConstants.response = response;
        DefaultContext.start(channel.eventLoop(), this.execController.getControl(), requestConstants, this.serverRegistry, this.handlers, execution -> {
            if (!transmitted.get()) {
                ByteBuf body;
                Handler lastHandler = requestConstants.handler;
                StringBuilder description = new StringBuilder();
                description.append("No response sent for ").append(request.getMethod().getName()).append(" request to ").append(request.getUri()).append(" (last handler: ");
                if (lastHandler instanceof DescribingHandler) {
                    ((DescribingHandler)lastHandler).describeTo(description);
                } else {
                    DescribingHandlers.describeTo(lastHandler, description);
                }
                description.append(")");
                String message = description.toString();
                LOGGER.warn(message);
                response.getHeaders().clear();
                if (this.development) {
                    CharBuffer charBuffer = CharBuffer.wrap(message);
                    body = ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)charBuffer, (Charset)CharsetUtil.UTF_8);
                    response.contentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
                } else {
                    body = ctx.alloc().buffer(0, 0);
                }
                response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, body.readableBytes());
                responseTransmitter.transmit(HttpResponseStatus.INTERNAL_SERVER_ERROR, body);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            LOGGER.error("", cause);
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ((DefaultResponseTransmitter)ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).get()).writabilityChanged();
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().equals("Connection reset by peer");
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)HttpHeaderConstants.PLAIN_TEXT_UTF8);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

