/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import java.util.List;
import ratpack.file.FileHandlerSpec;
import ratpack.file.internal.DefaultFileHandlerSpec;
import ratpack.file.internal.FileSystemBindingHandler;
import ratpack.func.Action;
import ratpack.func.Predicate;
import ratpack.handling.Chain;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainActionTransformer;
import ratpack.handling.internal.ChainBuilders;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.ClientErrorForwardingHandler;
import ratpack.handling.internal.NextHandler;
import ratpack.handling.internal.RegistryInsertHandler;
import ratpack.handling.internal.RegistryNextHandler;
import ratpack.http.internal.AcceptsHandler;
import ratpack.http.internal.ContentTypeHandler;
import ratpack.http.internal.MethodHandler;
import ratpack.http.internal.RedirectionHandler;
import ratpack.http.internal.RouteHandler;
import ratpack.path.PathBinder;
import ratpack.path.PathBinders;
import ratpack.path.internal.PathHandler;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;

public abstract class Handlers {
    private Handlers() {
    }

    public static Handler accepts(String ... contentTypes) {
        return new AcceptsHandler(contentTypes);
    }

    public static Handler files(ServerConfig serverConfig, Action<? super FileHandlerSpec> config) throws Exception {
        return DefaultFileHandlerSpec.build(serverConfig, config);
    }

    public static Handler chain(ServerConfig serverConfig, Action<? super Chain> action) throws Exception {
        return Handlers.chain(serverConfig, null, action);
    }

    public static Handler chain(ServerConfig serverConfig, Registry registry, Action<? super Chain> action) throws Exception {
        return ChainBuilders.build(serverConfig != null && serverConfig.isDevelopment(), new ChainActionTransformer(serverConfig, registry), action);
    }

    public static Handler chain(Registry registry, Action<? super Chain> action) throws Exception {
        return Handlers.chain(registry.get(ServerConfig.class), registry, action);
    }

    public static Handler chain(List<? extends Handler> handlers) {
        if (handlers.size() == 0) {
            return Context::next;
        }
        if (handlers.size() == 1) {
            return handlers.get(0);
        }
        return new ChainHandler(handlers);
    }

    public static Handler chain(Handler ... handlers) {
        if (handlers.length == 0) {
            return Handlers.next();
        }
        if (handlers.length == 1) {
            return handlers[0];
        }
        return new ChainHandler(handlers);
    }

    public static Handler clientError(int statusCode) {
        return new ClientErrorForwardingHandler(statusCode);
    }

    public static Handler contentTypes(String ... contentTypes) {
        return new ContentTypeHandler(contentTypes);
    }

    public static Handler delete() {
        return MethodHandler.DELETE;
    }

    public static Handler fileSystem(ServerConfig serverConfig, String path, Handler handler) {
        return new FileSystemBindingHandler(serverConfig, path, handler);
    }

    public static Handler get() {
        return MethodHandler.GET;
    }

    public static Handler next() {
        return NextHandler.INSTANCE;
    }

    public static Handler notFound() {
        return ClientErrorForwardingHandler.NOT_FOUND;
    }

    public static Handler patch() {
        return MethodHandler.PATCH;
    }

    public static Handler path(String path, Handler handler) {
        return Handlers.path(PathBinders.parse(path, true), handler);
    }

    public static Handler path(PathBinder pathBinder, Handler handler) {
        return new PathHandler(pathBinder, handler);
    }

    public static Handler post() {
        return MethodHandler.POST;
    }

    public static Handler prefix(String prefix, Handler handler) {
        return Handlers.path(PathBinders.parse(prefix, false), handler);
    }

    public static Handler put() {
        return MethodHandler.PUT;
    }

    public static Handler register(Registry registry, Handler handler) {
        return new RegistryInsertHandler(registry, handler);
    }

    public static Handler register(Registry registry) {
        return new RegistryNextHandler(registry);
    }

    public static Handler redirect(int code, String location) {
        return new RedirectionHandler(location, code);
    }

    public static Handler route(Predicate<? super Context> test, Handler handler) {
        return new RouteHandler(test, handler);
    }
}

