/*
 * Decompiled with CFR 0.152.
 */
package ratpack.jackson.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import ratpack.handling.Context;
import ratpack.http.TypedData;
import ratpack.jackson.JsonParseOpts;
import ratpack.parse.Parse;
import ratpack.parse.ParserSupport;
import ratpack.util.Types;

public class JsonParser
extends ParserSupport<JsonParseOpts> {
    private static final TypeToken<JsonNode> JSON_NODE_TYPE = TypeToken.of(JsonNode.class);
    private final ObjectMapper objectMapper;

    public JsonParser(ObjectMapper objectMapper) {
        super("application/json");
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T parse(Context context, TypedData body, Parse<T, JsonParseOpts> parse) throws IOException {
        JsonParseOpts opts = parse.getOpts();
        TypeToken<T> type = parse.getType();
        ObjectMapper objectMapper = this.getObjectMapper(opts);
        InputStream inputStream = body.getInputStream();
        if (type.equals(JSON_NODE_TYPE)) {
            return Types.cast(objectMapper.readTree(inputStream));
        }
        return (T)objectMapper.readValue(inputStream, this.toJavaType(type, objectMapper));
    }

    private <T> JavaType toJavaType(TypeToken<T> type, ObjectMapper objectMapper) {
        return objectMapper.getTypeFactory().constructType(type.getType());
    }

    private ObjectMapper getObjectMapper(JsonParseOpts opts) {
        return opts.getObjectMapper() == null ? this.objectMapper : opts.getObjectMapper();
    }
}

