/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.registry.Registry;

public class PathHandler
implements Handler {
    private static final LoadingCache<CacheKey, Optional<Registry>> CACHE = CacheBuilder.newBuilder().maximumSize(2048L).build((CacheLoader)new CacheLoader<CacheKey, Optional<Registry>>(){

        public Optional<Registry> load(CacheKey key) throws Exception {
            return key.pathBinder.bind(key.path, key.parentBinding).map(b -> Registry.single(PathBinding.class, b));
        }
    });
    private final PathBinder binder;
    private final Handler handler;

    public PathHandler(PathBinder binder, Handler handler) {
        this.binder = binder;
        this.handler = handler;
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        Optional registry = (Optional)CACHE.get((Object)new CacheKey(this.binder, context.getRequest().getPath(), context.maybeGet(PathBinding.class)));
        if (registry.isPresent()) {
            context.insert((Registry)registry.get(), this.handler);
        } else {
            context.next();
        }
    }

    private static class CacheKey {
        private final PathBinder pathBinder;
        private final String path;
        private final Optional<PathBinding> parentBinding;

        public CacheKey(PathBinder pathBinder, String path, Optional<PathBinding> parentBinding) {
            this.pathBinder = pathBinder;
            this.path = path;
            this.parentBinding = parentBinding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parentBinding.equals(cacheKey.parentBinding) && this.path.equals(cacheKey.path) && this.pathBinder.equals(cacheKey.pathBinder);
        }

        public int hashCode() {
            int result = this.pathBinder.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.parentBinding.hashCode();
            return result;
        }
    }
}

