/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigData;
import ratpack.config.ConfigDataSpec;
import ratpack.config.ConfigObject;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.server.NoBaseDirException;
import ratpack.server.internal.DefaultServerConfigBuilder;
import ratpack.server.internal.ServerEnvironment;

public interface ServerConfig
extends ConfigData {
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;

    public static Builder embedded() {
        return ServerConfig.noBaseDir().development(true).port(0);
    }

    public static Builder embedded(Path baseDir) {
        return ServerConfig.baseDir(baseDir).development(true).port(0);
    }

    public static Builder noBaseDir() {
        return DefaultServerConfigBuilder.noBaseDir(ServerEnvironment.env());
    }

    public static Builder findBaseDir() {
        return ServerConfig.findBaseDir(".ratpack");
    }

    public static Builder findBaseDir(String markerFilePath) {
        return DefaultServerConfigBuilder.findBaseDir(ServerEnvironment.env(), markerFilePath);
    }

    public static Builder baseDir(Path baseDir) {
        return DefaultServerConfigBuilder.baseDir(ServerEnvironment.env(), baseDir);
    }

    public static Builder baseDir(File baseDir) {
        return ServerConfig.baseDir(baseDir.toPath());
    }

    public int getPort();

    public InetAddress getAddress();

    public ImmutableSet<ConfigObject<?>> getRequiredConfig();

    public boolean isDevelopment();

    public int getThreads();

    public URI getPublicAddress();

    public SSLContext getSSLContext();

    public boolean isRequireClientSslAuth();

    public int getMaxContentLength();

    public Optional<Integer> getConnectTimeoutMillis();

    public Optional<Integer> getMaxMessagesPerRead();

    public Optional<Integer> getReceiveBufferSize();

    public Optional<Integer> getWriteSpinCount();

    public boolean isHasBaseDir();

    public FileSystemBinding getBaseDir() throws NoBaseDirException;

    public static interface Builder
    extends ConfigDataSpec {
        public static final String DEFAULT_ENV_PREFIX = "RATPACK_";
        public static final String DEFAULT_PROP_PREFIX = "ratpack.";
        public static final String DEFAULT_BASE_DIR_MARKER_FILE_PATH = ".ratpack";

        public Builder port(int var1);

        public Builder address(InetAddress var1);

        public Builder development(boolean var1);

        public Builder threads(int var1);

        public Builder publicAddress(URI var1);

        public Builder maxContentLength(int var1);

        public Builder connectTimeoutMillis(int var1);

        public Builder maxMessagesPerRead(int var1);

        public Builder receiveBufferSize(int var1);

        public Builder writeSpinCount(int var1);

        public Builder ssl(SSLContext var1);

        public Builder requireClientSslAuth(boolean var1);

        @Override
        public Builder env();

        @Override
        public Builder env(String var1);

        @Override
        public Builder props(ByteSource var1);

        @Override
        public Builder props(String var1);

        @Override
        public Builder props(Path var1);

        @Override
        public Builder props(Properties var1);

        @Override
        public Builder props(Map<String, String> var1);

        @Override
        public Builder props(URL var1);

        @Override
        public Builder sysProps();

        @Override
        public Builder sysProps(String var1);

        @Override
        public Builder onError(Action<? super Throwable> var1);

        @Override
        public Builder configureObjectMapper(Action<ObjectMapper> var1);

        @Override
        public Builder add(ConfigSource var1);

        @Override
        public Builder env(String var1, Function<String, String> var2);

        @Override
        public Builder env(EnvironmentParser var1);

        @Override
        public Builder json(ByteSource var1);

        @Override
        public Builder json(Path var1);

        @Override
        public Builder json(String var1);

        @Override
        public Builder json(URL var1);

        @Override
        public Builder yaml(ByteSource var1);

        @Override
        public Builder yaml(Path var1);

        @Override
        public Builder yaml(String var1);

        @Override
        public Builder yaml(URL var1);

        public Builder require(String var1, Class<?> var2);

        @Override
        public ServerConfig build();
    }
}

