/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.config.ConfigSource;
import ratpack.config.internal.ConfigDataLoader;
import ratpack.config.internal.ConfigDataReloadInformant;
import ratpack.config.internal.DefaultConfigObject;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;
import ratpack.server.StartEvent;
import ratpack.server.StopEvent;
import ratpack.util.Exceptions;

public class DefaultConfigData
implements ConfigData {
    private final ObjectMapper objectMapper;
    private final ObjectNode rootNode;
    private final ConfigDataReloadInformant reloadInformant;
    private final ObjectNode emptyNode;

    public DefaultConfigData(ObjectMapper objectMapper, Iterable<ConfigSource> configSources) {
        this.objectMapper = objectMapper;
        ConfigDataLoader loader = new ConfigDataLoader(this.objectMapper, configSources);
        this.rootNode = loader.load();
        this.reloadInformant = new ConfigDataReloadInformant(this.rootNode, loader);
        this.emptyNode = this.objectMapper.getNodeFactory().objectNode();
    }

    @Override
    public ObjectNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public <O> ConfigObject<O> getAsConfigObject(String pointer, Class<O> type) {
        ObjectNode node;
        Object object = node = pointer != null ? this.rootNode.at(pointer) : this.rootNode;
        if (node.isMissingNode()) {
            node = this.emptyNode;
        }
        try {
            Object value = this.objectMapper.readValue((JsonParser)new TreeTraversingParser((JsonNode)node, (ObjectCodec)this.objectMapper), type);
            return new DefaultConfigObject<Object>(pointer, type, value);
        }
        catch (IOException ex) {
            throw Exceptions.uncheck(ex);
        }
    }

    @Override
    public boolean shouldReload(Registry registry) {
        return this.reloadInformant.shouldReload(registry);
    }

    @Override
    public void onStart(StartEvent event) throws Exception {
        ServerConfig serverConfig = event.getRegistry().get(ServerConfig.class);
        if (serverConfig.isDevelopment()) {
            this.reloadInformant.onStart(event);
        }
    }

    @Override
    public void onStop(StopEvent event) throws Exception {
        ServerConfig serverConfig = event.getRegistry().get(ServerConfig.class);
        if (serverConfig.isDevelopment()) {
            this.reloadInformant.onStop(event);
        }
    }
}

