/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import ratpack.config.ConfigSource;
import ratpack.util.internal.Paths2;

public abstract class JacksonConfigSource
implements ConfigSource {
    private final ByteSource byteSource;

    public JacksonConfigSource(Path path) {
        this(Paths2.asByteSource(path));
    }

    public JacksonConfigSource(URL url) {
        this(Resources.asByteSource((URL)url));
    }

    public JacksonConfigSource(ByteSource byteSource) {
        this.byteSource = byteSource;
    }

    @Override
    public ObjectNode loadConfigData(ObjectMapper objectMapper) throws Exception {
        try (InputStream inputStream = this.byteSource.openStream();){
            JsonParser parser = this.getFactory(objectMapper).createParser(inputStream);
            ObjectNode objectNode = (ObjectNode)objectMapper.readTree(parser);
            return objectNode;
        }
    }

    protected abstract JsonFactory getFactory(ObjectMapper var1);
}

