/*
 * Decompiled with CFR 0.152.
 */
package ratpack.event.internal;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.event.internal.EventController;
import ratpack.event.internal.EventRegistry;
import ratpack.func.Action;

public class DefaultEventController<T>
implements EventController<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventController.class);
    private final List<Action<? super T>> handlers = new LinkedList<Action<? super T>>();
    private boolean fired;

    @Override
    public EventRegistry<T> getRegistry() {
        return eventHandler -> {
            if (this.fired) {
                LOGGER.warn("Cannot register event listener as event has been fired: " + eventHandler, (Throwable)new Exception());
            } else {
                this.handlers.add(eventHandler);
            }
        };
    }

    @Override
    public void fire(T payload) {
        if (this.fired) {
            LOGGER.warn("Cannot fire event with payload as event has been fired: " + payload, (Throwable)new Exception());
        } else {
            this.fired = true;
            for (Action<T> handler : this.handlers) {
                try {
                    handler.execute(payload);
                }
                catch (Exception e) {
                    LOGGER.warn("Ignoring exception thrown by event handler when receiving payload: " + payload, (Throwable)e);
                }
            }
        }
    }

    public boolean isHasListeners() {
        return !this.handlers.isEmpty();
    }
}

