/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import ratpack.exec.Downstream;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.exec.internal.ThreadBinding;
import ratpack.func.Block;
import ratpack.func.Factory;

public abstract class Blocking {
    private Blocking() {
    }

    public static <T> Promise<T> get(final Factory<T> factory) {
        return new DefaultPromise(downstream -> {
            final ExecutionBacking backing = ExecutionBacking.require();
            backing.streamSubscribe(streamHandle -> CompletableFuture.supplyAsync(new Supplier<Result<T>>(){
                Result result;

                @Override
                public Result<T> get() {
                    try {
                        ExecutionBacking.THREAD_BINDING.set(backing);
                        backing.intercept(ExecInterceptor.ExecType.BLOCKING, backing.getAllInterceptors().iterator(), () -> {
                            Object value = factory.create();
                            this.result = Result.success(value);
                        });
                        Result result = this.result;
                        return result;
                    }
                    catch (Exception e) {
                        Result result = Result.error(e);
                        return result;
                    }
                    finally {
                        ExecutionBacking.THREAD_BINDING.remove();
                    }
                }
            }, backing.getExecution().getController().getBlockingExecutor()).thenAcceptAsync(v -> streamHandle.complete(() -> downstream.accept(v)), (Executor)backing.getEventLoop()));
        });
    }

    public static <T> T on(Promise<T> promise) throws Exception {
        ThreadBinding.requireBlockingThread("Blocking.on() can only be used while blocking (i.e. use Blocking.get() first)");
        ExecutionBacking backing = ExecutionBacking.require();
        CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference resultReference = new AtomicReference();
        backing.streamSubscribe(handle -> promise.connect(new Downstream<T>((ExecutionBacking.StreamHandle)handle, latch){
            final /* synthetic */ ExecutionBacking.StreamHandle val$handle;
            final /* synthetic */ CountDownLatch val$cap$2;
            {
                this.val$handle = streamHandle;
                this.val$cap$2 = countDownLatch;
            }

            @Override
            public void success(T value) {
                this.unlatch(Result.success(value));
            }

            @Override
            public void error(Throwable throwable) {
                this.unlatch(Result.error(throwable));
            }

            @Override
            public void complete() {
                this.unlatch(Result.success(null));
            }

            private void unlatch(Result<T> result) {
                resultReference.set(result);
                this.val$handle.complete();
                this.val$cap$2.countDown();
            }
        }));
        backing.eventLoopDrain();
        latch.await();
        return ((Result)resultReference.get()).getValueOrThrow();
    }

    public static Operation op(Block block) {
        return Blocking.get(() -> {
            block.execute();
            return null;
        }).operation();
    }

    public static void exec(Block block) {
        Blocking.op(block).then();
    }
}

