/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;
import ratpack.exec.ExecResult;
import ratpack.exec.Result;
import ratpack.func.Action;
import ratpack.func.Block;

public interface Downstream<T> {
    public void success(T var1);

    public void error(Throwable var1);

    public void complete();

    default public <O> Downstream<O> onSuccess(final Action<? super O> action) {
        return new Downstream<O>(){

            @Override
            public void success(O value) {
                try {
                    action.execute(value);
                }
                catch (Throwable e) {
                    Downstream.this.error(e);
                }
            }

            @Override
            public void error(Throwable throwable) {
                Downstream.this.error(throwable);
            }

            @Override
            public void complete() {
                Downstream.this.complete();
            }
        };
    }

    default public Downstream<T> onError(final Action<? super Throwable> action) {
        return new Downstream<T>(){

            @Override
            public void success(T value) {
                Downstream.this.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                try {
                    action.execute(throwable);
                }
                catch (Exception e) {
                    e.addSuppressed(throwable);
                    Downstream.this.error(e);
                }
            }

            @Override
            public void complete() {
                Downstream.this.complete();
            }
        };
    }

    default public Downstream<T> onComplete(final Block block) {
        return new Downstream<T>(){

            @Override
            public void success(T value) {
                Downstream.this.success(value);
            }

            @Override
            public void error(Throwable throwable) {
                Downstream.this.error(throwable);
            }

            @Override
            public void complete() {
                try {
                    block.execute();
                }
                catch (Exception e) {
                    Downstream.this.error(e);
                }
            }
        };
    }

    default public void accept(ExecResult<? extends T> result) {
        if (result.isComplete()) {
            this.complete();
        } else if (result.isError()) {
            this.error(result.getThrowable());
        } else {
            this.success(result.getValue());
        }
    }

    default public void accept(Result<? extends T> result) {
        if (result.isError()) {
            this.error(result.getThrowable());
        } else {
            this.success(result.getValue());
        }
    }

    default public void accept(CompletableFuture<? extends T> future) {
        future.handle((value, failure) -> {
            if (failure == null) {
                this.success(value);
            } else {
                this.error((Throwable)failure);
            }
            return null;
        });
    }

    default public void accept(ListenableFuture<? extends T> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                Downstream.this.success(result);
            }

            public void onFailure(Throwable t) {
                Downstream.this.error(t);
            }
        });
    }
}

