/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.util.Objects;
import ratpack.exec.Downstream;
import ratpack.exec.Operation;
import ratpack.exec.Result;
import ratpack.exec.Throttle;
import ratpack.exec.Upstream;
import ratpack.exec.internal.CachingUpstream;
import ratpack.exec.internal.DefaultOperation;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.func.Pair;
import ratpack.func.Predicate;

public interface Promise<T> {
    public static <T> Promise<T> of(Upstream<T> upstream) {
        return new DefaultPromise<T>(ExecutionBacking.upstream(upstream));
    }

    public static <T> Promise<T> value(T t) {
        return Promise.of(f -> f.success(t));
    }

    public static <T> Promise<T> ofLazy(Factory<T> factory) {
        return Promise.of(f -> f.success(factory.create()));
    }

    public static <T> Promise<T> error(Throwable t) {
        return Promise.of(f -> f.error(t));
    }

    public void then(Action<? super T> var1);

    public void connect(Downstream<T> var1);

    public <O> Promise<O> transform(Function<? super Upstream<? extends T>, ? extends Upstream<O>> var1);

    default public Promise<T> onError(Action<? super Throwable> errorHandler) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            try {
                errorHandler.execute((Throwable)throwable);
            }
            catch (Throwable e) {
                e.addSuppressed((Throwable)throwable);
                down.error(e);
                return;
            }
            down.complete();
        })));
    }

    default public void result(Action<? super Result<T>> resultHandler) {
        this.onError(t -> resultHandler.execute(Result.error(t))).then(v -> resultHandler.execute(Result.success(v)));
    }

    default public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                Object apply = transformer.apply((Object)value);
                down.success(apply);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public <O> Promise<O> next(Promise<O> next) {
        return this.flatMap(in -> next);
    }

    default public <O> Promise<Pair<O, T>> left(Promise<O> left) {
        return this.flatMap(right -> left.map(value -> Pair.of(value, right)));
    }

    default public <O> Promise<Pair<T, O>> right(Promise<O> right) {
        return this.flatMap(left -> right.map(value -> Pair.of(left, value)));
    }

    default public Operation operation() {
        return this.operation(Action.noop());
    }

    default public Operation operation(Action<? super T> action) {
        return new DefaultOperation(this.map(t -> {
            action.execute(t);
            return null;
        }));
    }

    default public Promise<T> mapError(Function<? super Throwable, ? extends T> transformer) {
        return this.transform(up -> down -> up.connect(down.onError(throwable -> {
            try {
                down.success(transformer.apply((Throwable)throwable));
            }
            catch (Throwable t) {
                t.addSuppressed((Throwable)throwable);
                down.error(t);
            }
        })));
    }

    default public <O> Promise<O> apply(Function<? super Promise<T>, ? extends Promise<O>> function) {
        try {
            return function.apply(this);
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    default public <O> O to(Function<? super Promise<T>, ? extends O> function) throws Exception {
        return function.apply(this);
    }

    default public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                ((Promise)transformer.apply((Object)value)).onError(down::error).then(down::success);
            }
            catch (Throwable e) {
                down.error(e);
            }
        })));
    }

    default public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            boolean apply;
            try {
                apply = predicate.apply(value);
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            if (apply) {
                try {
                    action.execute(value);
                    down.complete();
                }
                catch (Throwable e) {
                    down.error(e);
                }
            } else {
                down.success(value);
            }
        })));
    }

    default public Promise<T> onNull(Block action) {
        return this.route(Objects::isNull, Action.ignoreArg(action));
    }

    default public Promise<T> cache() {
        return this.transform(CachingUpstream::new);
    }

    default public Promise<T> defer(Action<? super Runnable> releaser) {
        return this.transform(up -> down -> ExecutionBacking.require().streamSubscribe(streamHandle -> {
            try {
                releaser.execute(() -> streamHandle.complete(() -> up.connect(down)));
            }
            catch (Throwable t) {
                down.error(t);
            }
        }));
    }

    default public Promise<T> onYield(Runnable onYield) {
        return this.transform(up -> down -> {
            try {
                onYield.run();
            }
            catch (Throwable e) {
                down.error(e);
                return;
            }
            up.connect(down);
        });
    }

    default public Promise<T> wiretap(Action<? super Result<T>> listener) {
        return this.transform(up -> down -> up.connect(down.onSuccess(value -> {
            try {
                listener.execute(Result.success(value));
            }
            catch (Throwable t) {
                down.error(t);
                return;
            }
            down.success(value);
        })));
    }

    default public Promise<T> throttled(Throttle throttle) {
        return throttle.throttle(this);
    }

    public static <T> Promise<T> wrap(Factory<? extends Promise<T>> factory) {
        try {
            return factory.create();
        }
        catch (Exception e) {
            return Promise.error(e);
        }
    }
}

