/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.FactoryHandler;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;

public class ChainBuilders {
    public static <T> Handler build(boolean reloadable, Function<List<Handler>, ? extends T> toChainBuilder, Action<? super T> chainBuilderAction) throws Exception {
        File classFile;
        if (reloadable && (classFile = ClassUtil.getClassFile(chainBuilderAction)) != null) {
            ReloadableFileBackedFactory<Handler> factory = new ReloadableFileBackedFactory<Handler>(classFile.toPath(), true, (file, bytes) -> ChainBuilders.create(toChainBuilder, chainBuilderAction));
            return new FactoryHandler(factory);
        }
        return ChainBuilders.create(toChainBuilder, chainBuilderAction);
    }

    private static <T> Handler create(Function<List<Handler>, ? extends T> toChainBuilder, Action<? super T> chainBuilderAction) throws Exception {
        LinkedList handlers = Lists.newLinkedList();
        T chainBuilder = toChainBuilder.apply(handlers);
        chainBuilderAction.execute(chainBuilder);
        return Handlers.chain(handlers.toArray(new Handler[handlers.size()]));
    }
}

