/*
 * Decompiled with CFR 0.152.
 */
package ratpack.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import ratpack.func.Function;
import ratpack.http.ResponseChunks;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.jackson.JsonParseOpts;
import ratpack.jackson.JsonRender;
import ratpack.jackson.internal.DefaultJsonParseOpts;
import ratpack.jackson.internal.DefaultJsonRender;
import ratpack.jackson.internal.JsonNoOptParser;
import ratpack.jackson.internal.JsonParser;
import ratpack.jackson.internal.JsonRenderer;
import ratpack.parse.NullParseOpts;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.render.Renderer;
import ratpack.stream.Streams;
import ratpack.stream.WriteStream;

public abstract class Jackson {
    private Jackson() {
    }

    public static JsonRender json(Object object) {
        return new DefaultJsonRender(object, null, null);
    }

    public static JsonRender json(Object object, ObjectWriter objectWriter) {
        return new DefaultJsonRender(object, objectWriter);
    }

    public static JsonRender json(Object object, Class<?> viewClass) {
        return new DefaultJsonRender(object, viewClass);
    }

    public static JsonRender json(Object object, ObjectWriter objectWriter, Class<?> viewClass) {
        return new DefaultJsonRender(object, objectWriter, viewClass);
    }

    public static Parse<JsonNode, JsonParseOpts> jsonNode() {
        return Jackson.jsonNode(null);
    }

    public static Parse<JsonNode, JsonParseOpts> jsonNode(ObjectMapper objectMapper) {
        return Jackson.fromJson(JsonNode.class, objectMapper);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(Class<T> type) {
        return Jackson.fromJson(type, null);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(TypeToken<T> type) {
        return Jackson.fromJson(type, null);
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(Class<T> type, ObjectMapper objectMapper) {
        return Parse.of(type, new DefaultJsonParseOpts(objectMapper));
    }

    public static <T> Parse<T, JsonParseOpts> fromJson(TypeToken<T> type, ObjectMapper objectMapper) {
        return Parse.of(type, new DefaultJsonParseOpts(objectMapper));
    }

    public static <T> ResponseChunks chunkedJsonList(Registry registry, Publisher<T> stream) {
        return Jackson.chunkedJsonList(registry.get(ObjectWriter.class), stream);
    }

    public static <T> ResponseChunks chunkedJsonList(ObjectWriter objectWriter, Publisher<T> stream) {
        return ResponseChunks.bufferChunks(HttpHeaderConstants.JSON, Streams.streamMap(stream, out -> {
            final JsonGenerator generator = objectWriter.getFactory().createGenerator(new OutputStream((WriteStream)out){
                final /* synthetic */ WriteStream val$out;
                {
                    this.val$out = writeStream;
                }

                @Override
                public void write(int b) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.val$out.item(Unpooled.copiedBuffer((byte[])b, (int)off, (int)len));
                }
            });
            generator.writeStartArray();
            return new WriteStream<T>((WriteStream)out){
                final /* synthetic */ WriteStream val$out;
                {
                    this.val$out = writeStream;
                }

                @Override
                public void item(T item) {
                    try {
                        generator.writeObject(item);
                    }
                    catch (Exception e) {
                        this.val$out.error(e);
                    }
                }

                @Override
                public void error(Throwable throwable) {
                    this.val$out.error(throwable);
                }

                @Override
                public void complete() {
                    try {
                        generator.writeEndArray();
                        generator.close();
                        this.val$out.complete();
                    }
                    catch (IOException e) {
                        this.val$out.error(e);
                    }
                }
            };
        }));
    }

    public static <T> Function<T, String> toJson(Registry registry) {
        return arg_0 -> ((ObjectWriter)registry.get(ObjectWriter.class)).writeValueAsString(arg_0);
    }

    public static abstract class Init {
        public static Renderer<JsonRender> renderer(ObjectWriter objectWriter) {
            return new JsonRenderer(objectWriter);
        }

        public static Parser<NullParseOpts> noOptParser() {
            return new JsonNoOptParser();
        }

        public static Parser<JsonParseOpts> parser(ObjectMapper objectMapper) {
            return new JsonParser(objectMapper);
        }

        public static RegistrySpec register(RegistrySpec registrySpec, ObjectMapper objectMapper, ObjectWriter objectWriter) {
            return registrySpec.add(new TypeToken<ObjectWriter>(){}, objectWriter).add(new TypeToken<Renderer<JsonRender>>(){}, Init.renderer(objectWriter)).add(new TypeToken<Parser<NullParseOpts>>(){}, Init.noOptParser()).add(new TypeToken<Parser<JsonParseOpts>>(){}, Init.parser(objectMapper));
        }
    }
}

