/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.URI;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.DefaultServerConfigBuilder;

public interface ServerConfig
extends ConfigData {
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;

    public static ServerConfigBuilder embedded() {
        return ServerConfig.builder().development(true).port(0);
    }

    public static ServerConfigBuilder builder() {
        return new DefaultServerConfigBuilder(ConfigData.builder());
    }

    public static ServerConfig of(Action<? super ServerConfigBuilder> action) throws Exception {
        return action.with(ServerConfig.builder()).build();
    }

    public int getPort();

    public InetAddress getAddress();

    public ImmutableSet<ConfigObject<?>> getRequiredConfig();

    public boolean isDevelopment();

    public int getThreads();

    public URI getPublicAddress();

    public SSLContext getSSLContext();

    public boolean isRequireClientSslAuth();

    public int getMaxContentLength();

    public Optional<Integer> getConnectTimeoutMillis();

    public Optional<Integer> getMaxMessagesPerRead();

    public Optional<Integer> getReceiveBufferSize();

    public Optional<Integer> getWriteSpinCount();

    public boolean isHasBaseDir();

    public FileSystemBinding getBaseDir() throws NoBaseDirException;
}

