/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.handling.Handler;
import ratpack.launch.LaunchConfig;
import ratpack.server.Stopper;
import ratpack.server.internal.NettyHandlerAdapter;

public class RatpackChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private NettyHandlerAdapter nettyHandlerAdapter;
    private SSLContext sslContext;
    private int maxContentLength;

    public RatpackChannelInitializer(LaunchConfig launchConfig, Handler handler, Stopper stopper) {
        this.nettyHandlerAdapter = new NettyHandlerAdapter(stopper, handler, launchConfig);
        this.sslContext = launchConfig.getSSLContext();
        this.maxContentLength = launchConfig.getMaxContentLength();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)this.nettyHandlerAdapter);
    }
}

