/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import ratpack.config.ConfigData;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.func.Action;
import ratpack.func.Function;

public interface ConfigDataBuilder {
    public static final String DEFAULT_ENV_PREFIX = "RATPACK_";
    public static final String DEFAULT_PROP_PREFIX = "ratpack.";

    public ConfigData build();

    public ConfigDataBuilder configureObjectMapper(Action<ObjectMapper> var1);

    public ConfigDataBuilder add(ConfigSource var1);

    public ConfigDataBuilder env();

    public ConfigDataBuilder env(String var1);

    public ConfigDataBuilder env(String var1, Function<String, String> var2);

    public ConfigDataBuilder env(EnvironmentParser var1);

    public ConfigDataBuilder json(ByteSource var1);

    public ConfigDataBuilder json(Path var1);

    public ConfigDataBuilder json(String var1);

    public ConfigDataBuilder json(URL var1);

    public ConfigDataBuilder props(ByteSource var1);

    public ConfigDataBuilder props(Path var1);

    public ConfigDataBuilder props(Properties var1);

    public ConfigDataBuilder props(Map<String, String> var1);

    public ConfigDataBuilder props(String var1);

    public ConfigDataBuilder props(URL var1);

    public ConfigDataBuilder sysProps();

    public ConfigDataBuilder sysProps(String var1);

    public ConfigDataBuilder yaml(ByteSource var1);

    public ConfigDataBuilder yaml(Path var1);

    public ConfigDataBuilder yaml(String var1);

    public ConfigDataBuilder yaml(URL var1);

    public ConfigDataBuilder onError(Action<? super Throwable> var1);

    public ObjectMapper getObjectMapper();

    default public ConfigDataBuilder jacksonModules(Module ... modules) {
        this.getObjectMapper().registerModules(modules);
        return this;
    }

    public ImmutableList<ConfigSource> getConfigSources();
}

