/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health;

import ratpack.exec.Promise;
import ratpack.func.Function;
import ratpack.registry.Registry;

public interface HealthCheck {
    public String getName();

    public Promise<Result> check(Registry var1) throws Exception;

    public static HealthCheck of(final String name, final Function<? super Registry, ? extends Promise<Result>> func) {
        return new HealthCheck(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Promise<Result> check(Registry registry) throws Exception {
                return (Promise)func.apply(registry);
            }
        };
    }

    public static class Result {
        private static final Result HEALTHY = new Result(true, null, null);
        private final boolean healthy;
        private final String message;
        private final Throwable error;

        private Result(boolean healthy, String message, Throwable error) {
            this.healthy = healthy;
            this.message = message;
            this.error = error;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getError() {
            return this.error;
        }

        public static Result healthy() {
            return HEALTHY;
        }

        public static Result healthy(String message) {
            return new Result(true, message, null);
        }

        public static Result healthy(String message, Object ... args) {
            return Result.healthy(String.format(message, args));
        }

        public static Result unhealthy(String message) {
            return new Result(false, message, null);
        }

        public static Result unhealthy(String message, Object ... args) {
            return Result.unhealthy(String.format(message, args));
        }

        public static Result unhealthy(Throwable error) {
            return new Result(false, error.getMessage(), error);
        }
    }
}

