/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.ContentAggregatingRequestAction;
import ratpack.http.client.internal.ContentStreamingRequestAction;

public class DefaultHttpClient
implements HttpClient {
    private final ByteBufAllocator byteBufAllocator;
    private final int maxContentLengthBytes;

    public DefaultHttpClient(ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        this.byteBufAllocator = byteBufAllocator;
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.request(uri, requestConfigurer);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, new Post().append(action));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return Promise.of(f -> new ContentAggregatingRequestAction(requestConfigurer, uri, Execution.current(), this.byteBufAllocator, this.maxContentLengthBytes, 0).connect(f));
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return Promise.of(f -> new ContentStreamingRequestAction(requestConfigurer, uri, Execution.current(), this.byteBufAllocator, 0).connect(f));
    }

    private static class Post
    implements Action<RequestSpec> {
        private Post() {
        }

        @Override
        public void execute(RequestSpec requestSpec) throws Exception {
            requestSpec.method("POST");
        }
    }
}

