/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import java.util.List;
import java.util.stream.Stream;
import ratpack.config.EnvironmentParser;
import ratpack.func.Function;
import ratpack.func.Pair;

public class DefaultEnvironmentParser
implements EnvironmentParser {
    private final Function<Pair<String, String>, Stream<Pair<String, String>>> filterFunc;
    private final Function<String, List<String>> tokenizeFunc;
    private final Function<String, String> mapFunc;

    DefaultEnvironmentParser(Function<Pair<String, String>, Stream<Pair<String, String>>> filterFunc, Function<String, List<String>> tokenizeFunc, Function<String, String> mapFunc) {
        this.filterFunc = filterFunc;
        this.tokenizeFunc = tokenizeFunc;
        this.mapFunc = mapFunc;
    }

    @Override
    public Stream<Pair<String, String>> filter(Pair<String, String> entry) throws Exception {
        return this.filterFunc.apply(entry);
    }

    @Override
    public List<String> tokenize(String name) throws Exception {
        return this.tokenizeFunc.apply(name);
    }

    @Override
    public String map(String segment) throws Exception {
        return this.mapFunc.apply(segment);
    }
}

