/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import ratpack.http.MediaType;
import ratpack.util.Exceptions;

public class DefaultMediaType
implements MediaType {
    public static final String CHARSET_KEY = "charset";
    private final String type;
    private final ImmutableListMultimap<String, String> params;
    private final String string;
    private static final int CACHE_SIZE = 200;
    private static final Cache<String, MediaType> CACHE = CacheBuilder.newBuilder().maximumSize(200L).build();

    public static MediaType get(String contentType) {
        String contentType1 = contentType;
        contentType1 = contentType1 == null ? "" : contentType1.trim();
        String finalContentType = contentType1;
        try {
            return (MediaType)CACHE.get((Object)contentType1, () -> new DefaultMediaType(finalContentType));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Exceptions.uncheck(Exceptions.toException(e.getCause()));
        }
    }

    public DefaultMediaType(String value) {
        if (value == null || value.trim().length() == 0) {
            this.type = null;
            this.params = ImmutableListMultimap.of();
            this.string = "";
        } else {
            com.google.common.net.MediaType mediaType = com.google.common.net.MediaType.parse((String)value.trim());
            if (mediaType != null && mediaType.type() != null) {
                this.type = mediaType.subtype() != null ? mediaType.type() + "/" + mediaType.subtype() : mediaType.type();
                this.params = mediaType.parameters();
                this.string = mediaType.toString();
            } else {
                this.type = null;
                this.params = ImmutableListMultimap.of();
                this.string = "";
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ImmutableListMultimap<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getCharset() {
        return this.getCharset(null);
    }

    @Override
    public String getCharset(String defaultCharset) {
        ImmutableList charsetValues = this.params.get((Object)CHARSET_KEY);
        switch (charsetValues.size()) {
            case 0: {
                return defaultCharset;
            }
            case 1: {
                return Charset.forName((String)charsetValues.get(0)).toString();
            }
        }
        throw new IllegalStateException("Multiple charset values defined: " + charsetValues);
    }

    @Override
    public boolean isText() {
        return this.getType() != null && this.getType().startsWith("text/");
    }

    @Override
    public boolean isJson() {
        return this.getType() != null && this.getType().equals("application/json");
    }

    @Override
    public boolean isForm() {
        return this.getType() != null && this.getType().equals("application/x-www-form-urlencoded");
    }

    @Override
    public boolean isHtml() {
        return this.getType() != null && this.getType().equals("text/html");
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == null;
    }

    public String toString() {
        return this.string;
    }
}

