/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import ratpack.func.Function;
import ratpack.sse.Event;
import ratpack.sse.internal.ServerSentEventDecoder;
import ratpack.stream.WriteStream;

public class ServerSentEventStreamMapDecoder
implements Function<WriteStream<Event<?>>, WriteStream<ByteBuf>> {
    private final ByteBufAllocator bufferAllocator;

    public ServerSentEventStreamMapDecoder(ByteBufAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    @Override
    public WriteStream<ByteBuf> apply(final WriteStream<Event<?>> sseWriteStream) throws Exception {
        return new WriteStream<ByteBuf>(){

            @Override
            public void item(ByteBuf item) {
                try {
                    ServerSentEventDecoder.INSTANCE.decode(item, ServerSentEventStreamMapDecoder.this.bufferAllocator, sseWriteStream::item);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }

            @Override
            public void error(Throwable throwable) {
                sseWriteStream.error(throwable);
            }

            @Override
            public void complete() {
                sseWriteStream.complete();
            }
        };
    }
}

