/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import ratpack.exec.Blocking;
import ratpack.server.internal.ResponseWriter;
import ratpack.server.internal.ResponseWritingListener;

class ZeroCopyFileResponseWriter
implements ResponseWriter {
    private static final Set<OpenOption> OPEN_OPTIONS = Collections.singleton(StandardOpenOption.READ);
    private final Path file;
    private final long size;

    ZeroCopyFileResponseWriter(Path file, long size) {
        this.file = file;
        this.size = size;
    }

    @Override
    public void write(Channel channel, Consumer<? super ResponseWritingListener> listenerReceiver, Consumer<? super ChannelFuture> then) {
        Blocking.get(() -> FileChannel.open(this.file, OPEN_OPTIONS, new FileAttribute[0])).then(fileChannel -> {
            channel.write((Object)new DefaultFileRegion(fileChannel, 0L, this.size), channel.voidPromise());
            then.accept(channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT));
        });
    }
}

