/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.collect.ImmutableList;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.ExecStarter;
import ratpack.exec.Execution;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.exec.internal.ThreadBinding;
import ratpack.func.Action;
import ratpack.registry.RegistrySpec;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultExecController
implements ExecControllerInternal {
    private static final Action<Throwable> LOG_UNCAUGHT = t -> DefaultExecution.LOGGER.error("Uncaught execution exception", t);
    private final ExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final int numThreads;
    private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
    private ImmutableList<? extends ExecInterceptor> interceptors = ImmutableList.of();
    private ImmutableList<? extends ExecInitializer> initializers = ImmutableList.of();

    public DefaultExecController() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public DefaultExecController(int numThreads) {
        this.numThreads = numThreads;
        this.eventLoopGroup = ChannelImplDetector.eventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory(true, "ratpack-compute", 10)));
        this.blockingExecutor = Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory(false, "ratpack-blocking", 5)));
    }

    @Override
    public void setInterceptors(ImmutableList<? extends ExecInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void setInitializers(ImmutableList<? extends ExecInitializer> initializers) {
        this.initializers = initializers;
    }

    @Override
    public ImmutableList<? extends ExecInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public ImmutableList<? extends ExecInitializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecutorService getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public ExecStarter fork() {
        return new ExecStarter(){
            private Action<? super Throwable> onError = DefaultExecController.access$100();
            private Action<? super Execution> onComplete = Action.noop();
            private Action<? super Execution> onStart = Action.noop();
            private Action<? super RegistrySpec> registry = Action.noop();
            private EventLoop eventLoop = DefaultExecController.this.getEventLoopGroup().next();

            @Override
            public ExecStarter eventLoop(EventLoop eventLoop) {
                this.eventLoop = eventLoop;
                return this;
            }

            @Override
            public ExecStarter onError(Action<? super Throwable> onError) {
                this.onError = onError;
                return this;
            }

            @Override
            public ExecStarter onComplete(Action<? super Execution> onComplete) {
                this.onComplete = onComplete;
                return this;
            }

            @Override
            public ExecStarter onStart(Action<? super Execution> onStart) {
                this.onStart = onStart;
                return this;
            }

            @Override
            public ExecStarter register(Action<? super RegistrySpec> action) {
                this.registry = action;
                return this;
            }

            @Override
            public void start(Action<? super Execution> initialExecutionSegment) {
                if (this.eventLoop.inEventLoop() && DefaultExecution.get() == null) {
                    try {
                        new DefaultExecution(DefaultExecController.this, this.eventLoop, this.registry, initialExecutionSegment, this.onError, this.onStart, this.onComplete);
                    }
                    catch (Exception e) {
                        throw new InternalError("could not start execution", e);
                    }
                } else {
                    this.eventLoop.submit(() -> new DefaultExecution(DefaultExecController.this, this.eventLoop, this.registry, initialExecutionSegment, this.onError, this.onStart, this.onComplete));
                }
            }
        };
    }

    static /* synthetic */ Action access$100() {
        return LOG_UNCAUGHT;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        private final boolean compute;

        public ExecControllerBindingThreadFactory(boolean compute, String name, int priority) {
            super(name, priority);
            this.compute = compute;
        }

        public Thread newThread(Runnable r) {
            return super.newThread(() -> {
                ThreadBinding.bind(this.compute, DefaultExecController.this);
                Thread.currentThread().setContextClassLoader(DefaultExecController.this.contextClassLoader);
                r.run();
            });
        }
    }
}

