/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import java.net.URI;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.func.Action;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.RequestActionSupport;

class ContentAggregatingRequestAction
extends RequestActionSupport<ReceivedResponse> {
    private final int maxContentLengthBytes;

    public ContentAggregatingRequestAction(Action<? super RequestSpec> requestConfigurer, URI uri, Execution execution, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes, int redirectCount) {
        super(requestConfigurer, uri, execution, byteBufAllocator, redirectCount);
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    protected void addResponseHandlers(ChannelPipeline p, final Downstream<? super ReceivedResponse> fulfiller) {
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLengthBytes));
        p.addLast("httpResponseHandler", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(false){

            public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                ContentAggregatingRequestAction.this.success(fulfiller, ContentAggregatingRequestAction.this.toReceivedResponse(msg));
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
                ContentAggregatingRequestAction.this.error(fulfiller, cause);
            }
        });
    }

    @Override
    protected RequestActionSupport<ReceivedResponse> buildRedirectRequestAction(Action<? super RequestSpec> redirectRequestConfig, URI locationUrl, int redirectCount) {
        return new ContentAggregatingRequestAction(redirectRequestConfig, locationUrl, this.execution, this.byteBufAllocator, this.maxContentLengthBytes, redirectCount);
    }
}

