/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import ratpack.func.Function;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.registry.internal.TypeCaching;

public class SingleEntryRegistry
implements Registry {
    private final RegistryEntry<?> entry;

    public SingleEntryRegistry(RegistryEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        if (TypeCaching.isAssignableFrom(TypeCaching.cache(type), type, this.entry.getType())) {
            Object cast = this.entry.get();
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.maybeGet(type).map(o -> Collections.singleton(o)).orElse(Collections.emptySet());
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        Optional<T> item = this.maybeGet(type);
        if (item.isPresent()) {
            return Optional.ofNullable(function.apply(item.get()));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleEntryRegistry that = (SingleEntryRegistry)o;
        return this.entry.equals(that.entry);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public String toString() {
        return "SingleEntryRegistry{" + this.entry + '}';
    }
}

