/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file;

import com.google.common.reflect.TypeToken;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import ratpack.api.Nullable;
import ratpack.file.internal.DefaultFileSystemBinding;
import ratpack.util.Types;

public interface FileSystemBinding {
    public static final TypeToken<FileSystemBinding> TYPE = Types.token(FileSystemBinding.class);

    public static FileSystemBinding root() {
        return FileSystemBinding.of(Paths.get(System.getProperty("user.dir"), new String[0]).getRoot());
    }

    public static FileSystemBinding of(Path path) {
        return new DefaultFileSystemBinding(Objects.requireNonNull(path, "path cannot be null"));
    }

    public Path getFile();

    @Nullable
    public Path file(String var1);

    public FileSystemBinding binding(String var1);
}

