/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.guice.internal;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import groovy.lang.Closure;
import java.util.function.Consumer;
import ratpack.func.Action;
import ratpack.groovy.guice.GroovyBindingsSpec;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.guice.BindingsSpec;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.Guice;
import ratpack.guice.NoSuchModuleException;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;

public class DefaultGroovyBindingsSpec
implements GroovyBindingsSpec {
    private final BindingsSpec delegate;

    public DefaultGroovyBindingsSpec(BindingsSpec delegate) {
        this.delegate = delegate;
    }

    @Override
    public GroovyBindingsSpec init(Closure<?> closure) {
        this.doInit(closure, Void.class, 2);
        return this;
    }

    private <T, N> void doInit(Closure<T> closure, Class<N> clazz, int resolveStrategy) {
        this.init(injector -> {
            Registry injectorBackedRegistry = Guice.registry((Injector)injector);
            Object delegate = clazz.equals(Void.class) ? null : injector.getInstance(clazz);
            new ClosureInvoker(closure).invoke(injectorBackedRegistry, delegate, resolveStrategy);
        });
    }

    public LaunchConfig getLaunchConfig() {
        return this.delegate.getLaunchConfig();
    }

    @Override
    public GroovyBindingsSpec bind(Class<?> type) {
        this.delegate.bind(type);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bind(Class<T> publicType, Class<? extends T> implType) {
        this.delegate.bind(publicType, implType);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bindInstance(Class<? super T> publicType, T instance) {
        this.delegate.bindInstance(publicType, instance);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bindInstance(T instance) {
        this.delegate.bindInstance(instance);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec providerType(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        this.delegate.providerType(publicType, providerType);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec provider(Class<T> publicType, Provider<? extends T> provider) {
        this.delegate.provider(publicType, provider);
        return this;
    }

    @Override
    public GroovyBindingsSpec init(Action<? super Injector> action) {
        this.delegate.init(action);
        return this;
    }

    @Override
    public GroovyBindingsSpec init(Class<? extends Runnable> clazz) {
        this.delegate.init(clazz);
        return this;
    }

    @Override
    public <T extends Module> GroovyBindingsSpec config(Class<T> moduleClass, Consumer<? super T> configurer) throws NoSuchModuleException {
        this.delegate.config(moduleClass, configurer);
        return this;
    }

    @Override
    public GroovyBindingsSpec binder(Action<? super Binder> action) {
        this.delegate.binder(action);
        return this;
    }

    @Override
    public GroovyBindingsSpec add(Module module) {
        this.delegate.add(module);
        return this;
    }

    @Override
    public GroovyBindingsSpec add(Class<? extends Module> module) {
        this.delegate.add(module);
        return this;
    }

    @Override
    public <C, T extends ConfigurableModule<C>> GroovyBindingsSpec add(Class<T> moduleClass, Action<? super C> configuration) {
        this.delegate.add(moduleClass, configuration);
        return this;
    }
}

