/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import ratpack.file.FileSystemBinding;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.groovy.templating.internal.TemplateRenderer;
import ratpack.guice.ConfigurableModule;
import ratpack.launch.LaunchConfig;

public class TemplatingModule
extends ConfigurableModule<Config> {
    protected void configure() {
        this.bind(TemplateRenderer.class);
    }

    @Provides
    @Singleton
    GroovyTemplateRenderingEngine provideGroovyTemplateRenderingEngine(LaunchConfig launchConfig, Config config) {
        String templatesPath = config.getTemplatesPath();
        FileSystemBinding templateDir = launchConfig.getBaseDir().binding(templatesPath);
        if (templateDir == null) {
            throw new IllegalStateException("templatesPath '" + templatesPath + "' is outside the file system binding");
        }
        return new GroovyTemplateRenderingEngine(launchConfig.getExecController().getControl(), launchConfig.getBufferAllocator(), templateDir, launchConfig.isDevelopment(), config.staticallyCompile);
    }

    public static class Config {
        private String templatesPath = "templates";
        private boolean staticallyCompile;

        public String getTemplatesPath() {
            return this.templatesPath;
        }

        public void setTemplatesPath(String templatesPath) {
            this.templatesPath = templatesPath;
        }

        public boolean isStaticallyCompile() {
            return this.staticallyCompile;
        }

        public void setStaticallyCompile(boolean staticallyCompile) {
            this.staticallyCompile = staticallyCompile;
        }
    }
}

