/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.InvalidTemplateException;
import ratpack.groovy.templating.internal.MapBackedTemplateModel;
import ratpack.groovy.templating.internal.NestedRenderer;

public class CompiledTemplate {
    private final Class<DefaultTemplateScript> templateClass;
    private final String templateName;

    public CompiledTemplate(String templateName, Class<DefaultTemplateScript> templateClass) {
        this.templateName = templateName;
        this.templateClass = templateClass;
    }

    void execute(Map<String, ?> model, ByteBuf buffer, NestedRenderer nestedRenderer) {
        Map<String, Object> modelTyped = model;
        MapBackedTemplateModel templateModel = new MapBackedTemplateModel(modelTyped);
        DefaultTemplateScript script = (DefaultTemplateScript)DefaultGroovyMethods.newInstance(this.templateClass, (Object[])new Object[]{templateModel, buffer, nestedRenderer});
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof InvalidTemplateException) {
                throw (InvalidTemplateException)e;
            }
            throw new InvalidTemplateException(this.templateName, "template execution failed", e);
        }
    }
}

