/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import groovy.lang.Script;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;
import ratpack.groovy.templating.TemplateModel;
import ratpack.groovy.templating.TemplateScript;
import ratpack.groovy.templating.internal.NestedRenderer;
import ratpack.util.internal.IoUtils;

public abstract class DefaultTemplateScript
extends Script
implements TemplateScript {
    private static final Escaper HTML_ESCAPER = HtmlEscapers.htmlEscaper();
    private static final Escaper URL_PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private static final Escaper URL_PARAM_ESCAPER = UrlEscapers.urlFormParameterEscaper();
    private final TemplateModel model;
    private final NestedRenderer renderer;
    private final ByteBuf buffer;

    protected DefaultTemplateScript(TemplateModel model, ByteBuf buffer, NestedRenderer renderer) {
        this.model = model;
        this.buffer = buffer;
        this.renderer = renderer;
    }

    @Override
    public TemplateModel getModel() {
        return this.model;
    }

    @Override
    public String render(String templateName) throws Exception {
        return this.render(Collections.emptyMap(), templateName);
    }

    @Override
    public String render(Map<String, ?> model, String templateName) throws Exception {
        this.renderer.render(templateName, model);
        return "";
    }

    @Override
    public String html(Object value) {
        return value == null ? "" : HTML_ESCAPER.escape(value.toString());
    }

    @Override
    public String urlPathSegment(Object value) {
        return value == null ? "" : URL_PATH_SEGMENT_ESCAPER.escape(value.toString());
    }

    @Override
    public String urlParam(Object value) {
        return value == null ? "" : URL_PARAM_ESCAPER.escape(value.toString());
    }

    public void $(CharSequence charSequence) {
        this.buffer.writeBytes(IoUtils.utf8Bytes((String)charSequence.toString()));
    }
}

